/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class IncidentUserOperationLogTest
extends PluggableProcessEngineTest {
    @Test
    public void shouldLogIncidentCreation() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        Incident incident = this.doAuthenticated(() -> this.runtimeService.createIncident("foo", processInstance.getId(), "aa", "bar"));
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(2L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("incidentType").singleResult();
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"CreateIncident");
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"ProcessInstance");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Operator");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)entry.getExecutionId()).isNull();
        Assertions.assertThat((String)entry.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)entry.getProcessDefinitionId()).isEqualTo((Object)processInstance.getProcessDefinitionId());
        Assertions.assertThat((String)entry.getProcessDefinitionKey()).isEqualTo((Object)"Process");
        entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("configuration").singleResult();
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"CreateIncident");
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"ProcessInstance");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Operator");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)incident.getConfiguration());
        Assertions.assertThat((String)entry.getExecutionId()).isNull();
        Assertions.assertThat((String)entry.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)entry.getProcessDefinitionId()).isEqualTo((Object)processInstance.getProcessDefinitionId());
        Assertions.assertThat((String)entry.getProcessDefinitionKey()).isEqualTo((Object)"Process");
    }

    @Test
    public void shouldNotLogIncidentCreationFailure() {
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        Assertions.assertThatThrownBy(() -> this.runtimeService.createIncident("foo", null, "userTask1", "bar")).isInstanceOf(BadUserRequestException.class);
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
    }

    @Test
    public void shouldLogIncidentResolution() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.doAuthenticated(() -> this.runtimeService.resolveIncident(incident.getId()));
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Resolve");
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"ProcessInstance");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Operator");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"incidentId");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)incident.getId());
        Assertions.assertThat((String)entry.getExecutionId()).isNull();
        Assertions.assertThat((String)entry.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)entry.getProcessDefinitionId()).isEqualTo((Object)processInstance.getProcessDefinitionId());
        Assertions.assertThat((String)entry.getProcessDefinitionKey()).isEqualTo((Object)"Process");
    }

    @Test
    public void shouldNotLogIncidentResolutionFailure() {
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        Assertions.assertThatThrownBy(() -> this.runtimeService.resolveIncident("foo")).isInstanceOf(NotFoundException.class);
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
    }

    @Test
    public void shouldLogSetAnnotationToIncident() {
        String annotation = "my annotation";
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.doAuthenticated(() -> this.runtimeService.setAnnotationForIncidentById(incident.getId(), annotation));
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"SetAnnotation");
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Incident");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Operator");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"incidentId");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)incident.getId());
    }

    @Test
    public void shouldLogClearAnnotationToIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.doAuthenticated(() -> this.runtimeService.clearAnnotationForIncidentById(incident.getId()));
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"ClearAnnotation");
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Incident");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Operator");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"incidentId");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)incident.getId());
    }

    protected <T> T doAuthenticated(Supplier<T> action) {
        this.identityService.setAuthenticatedUserId("userId");
        T result = action.get();
        this.identityService.clearAuthentication();
        return result;
    }

    protected void doAuthenticated(Runnable action) {
        this.identityService.setAuthenticatedUserId("userId");
        action.run();
        this.identityService.clearAuthentication();
    }
}

