/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigrationPlanAssert;
import org.camunda.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationPlanCreationTest {
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    public void testExplicitInstructionGeneration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateNonExistingSourceDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan("aNonExistingProcDefId", processDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "Source process definition with id 'aNonExistingProcDefId' does not exist");
        }
    }

    @Test
    public void testMigrateNullSourceDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(null, processDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "Source process definition id is null");
        }
    }

    @Test
    public void testMigrateNonExistingTargetDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(processDefinition.getId(), "aNonExistingProcDefId").mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "Target process definition with id 'aNonExistingProcDefId' does not exist");
        }
    }

    @Test
    public void testMigrateNullTargetDefinition() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(processDefinition.getId(), null).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (BadUserRequestException e) {
            this.assertExceptionMessage((Exception)((Object)e), "Target process definition id is null");
        }
    }

    @Test
    public void testMigrateNonExistingSourceActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("thisActivityDoesNotExist", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("thisActivityDoesNotExist", "Source activity 'thisActivityDoesNotExist' does not exist");
        }
    }

    @Test
    public void testMigrateNullSourceActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities(null, "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(null, "Source activity id is null");
        }
    }

    @Test
    public void testMigrateNonExistingTargetActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "thisActivityDoesNotExist").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'thisActivityDoesNotExist' does not exist");
        }
    }

    @Test
    public void testMigrateNullTargetActivityId() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", null).build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity id is null");
        }
    }

    @Test
    public void testMigrateTaskToHigherScope() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceDefinition).hasTargetProcessDefinition(targetDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateToUnsupportedActivityType() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_RECEIVE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "receiveTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Activities have incompatible types (UserTaskActivityBehavior is not compatible with ReceiveTaskActivityBehavior)");
        }
    }

    @Test
    public void testNotMigrateActivitiesOfDifferentType() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).swapElementIds("userTask", "subProcess"));
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Activities have incompatible types (UserTaskActivityBehavior is not compatible with SubProcessActivityBehavior)");
        }
    }

    @Test
    public void testNotMigrateBoundaryEventsOfDifferentType() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done());
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).done());
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "Events are not of the same type (boundaryMessage != boundarySignal)");
        }
    }

    @Test
    public void testMigrateSubProcessToProcessDefinition() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("subProcess", targetDefinition.getId()).build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("subProcess", "Target activity '" + targetDefinition.getId() + "' does not exist");
        }
    }

    @Test
    public void testMapEqualActivitiesWithParallelMultiInstance() {
        BpmnModelInstance testProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).getBuilderForElementById("userTask", UserTaskBuilder.class).multiInstance().parallel()).cardinality("3")).multiInstanceDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Target activity 'userTask' is a descendant of multi-instance body 'userTask#multiInstanceBody' that is not mapped from the source process definition.");
        }
    }

    @Test
    public void testMapEqualBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryEventsWithDifferentId() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("newBoundary"));
    }

    @Test
    public void testMapBoundaryToMigratedActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("userTask", "newUserTask");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("newUserTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryToParallelActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask2").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "The source activity's event scope (userTask1) must be mapped to the target activity's event scope (userTask2)");
        }
    }

    @Test
    public void testMapBoundaryToHigherScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryToLowerScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("boundary").to("boundary"));
    }

    @Test
    public void testMapBoundaryToChildActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "The source activity's event scope (subProcess) must be mapped to the target activity's event scope (userTask)");
        }
    }

    @Test
    public void testMapBoundaryToParentActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("boundary", "The source activity's event scope (userTask) must be mapped to the target activity's event scope (subProcess)", "The closest mapped ancestor 'subProcess' is mapped to scope 'subProcess' which is not an ancestor of target scope 'boundary'");
        }
    }

    @Test
    public void testMapAllBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("error").error(ERROR_CODE)).moveToActivity("subProcess").boundaryEvent("escalation").escalation(ESCALATION_CODE)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("error", "error").mapActivities("escalation", "escalation").mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("error").to("error"), MigrationPlanAssert.migrate("escalation").to("escalation"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapProcessDefinitionWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapSubProcessWithEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapActivityWithUnmappedParentWhichHasAEventSubProcessChild() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapUserTaskInEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().message(MESSAGE_NAME)).userTask("innerTask").endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("innerTask", "innerTask").build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("innerTask").to("innerTask"));
    }

    @Test
    public void testNotMapActivitiesMoreThanOnce() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask1", "userTask2").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask1", "There are multiple mappings for source activity id 'userTask1'", "There are multiple mappings for source activity id 'userTask1'");
        }
    }

    @Test
    public void testCannotUpdateEventTriggerForNonEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").updateEventTrigger().build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("userTask", "Cannot update event trigger because the activity does not define a persistent event trigger");
        }
    }

    @Test
    public void testCannotUpdateEventTriggerForEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").updateEventTrigger().build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("eventSubProcess", "Cannot update event trigger because the activity does not define a persistent event trigger");
        }
    }

    @Test
    public void testCanUpdateEventTriggerForEventSubProcessStartEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasInstructions(MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart").updateEventTrigger(true));
    }

    @Test
    public void shouldSetVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(Collections.singletonMap("foo", "bar")).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar"));
    }

    @Test
    public void shouldSetVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("foo", "bar");
        variables.put("bar", 5);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(variables).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar"), MigrationPlanAssert.variable().name("bar").value(5));
    }

    @Test
    public void shouldSetUntypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar")).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar"));
    }

    @Test
    public void shouldSetUntypedVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)5)).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar"), MigrationPlanAssert.variable().name("bar").value(5));
    }

    @Test
    public void shouldSetMapOfTypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(Collections.singletonMap("foo", Variables.stringValue((String)"bar"))).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar").typed());
    }

    @Test
    public void shouldSetVariableMapOfTypedVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)Variables.stringValue((String)"bar"))).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar").typed());
    }

    @Test
    public void shouldSetTypedAndUntypedVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValue((String)"foo", (Object)"bar").putValueTyped("bar", (TypedValue)Variables.integerValue((Integer)5))).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).hasVariables(MigrationPlanAssert.variable().name("foo").value("bar"), MigrationPlanAssert.variable().name("bar").value(5).typed());
    }

    @Test
    public void shouldSetNullVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(null).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).variablesNull();
    }

    @Test
    public void shouldSetEmptyVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables(new HashMap()).mapEqualActivities().build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition).variablesEmpty();
    }

    @Test
    public void shouldThrowValidationExceptionDueToSerializationFormatForbiddenForVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)Variables.serializedObjectValue().serializedValue("[]").objectTypeName(ArrayList.class.getName()).serializationDataFormat(Variables.SerializationDataFormats.JAVA.getName()).create())).mapEqualActivities().build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasVariableFailures("foo", "Cannot set variable with name foo. Java serialization format is prohibited");
        }
    }

    @Test
    public void shouldThrowValidationExceptionDueToSerializationFormatForbiddenForVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ObjectValue objectValue = (ObjectValue)Variables.serializedObjectValue().serializedValue("[]").objectTypeName(ArrayList.class.getName()).serializationDataFormat(Variables.SerializationDataFormats.JAVA.getName()).create();
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)objectValue).putValueTyped("bar", (TypedValue)objectValue)).mapEqualActivities().build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasVariableFailures("foo", "Cannot set variable with name foo. Java serialization format is prohibited").hasVariableFailures("bar", "Cannot set variable with name bar. Java serialization format is prohibited");
        }
    }

    @Test
    public void shouldThrowExceptionDueToInstructionsAndSerializationFormatForbiddenForVariable() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ObjectValue objectValue = (ObjectValue)Variables.serializedObjectValue().serializedValue("[]").objectTypeName(ArrayList.class.getName()).serializationDataFormat(Variables.SerializationDataFormats.JAVA.getName()).create();
        try {
            this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).setVariables((Map)Variables.putValueTyped((String)"foo", (TypedValue)objectValue)).mapActivities("foo", "bar").mapActivities("bar", "foo").build();
            Assert.fail((String)"Should not succeed");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasVariableFailures("foo", "Cannot set variable with name foo. Java serialization format is prohibited").hasInstructionFailures("foo", "Source activity 'foo' does not exist", "Target activity 'bar' does not exist").hasInstructionFailures("bar", "Source activity 'bar' does not exist", "Target activity 'foo' does not exist");
        }
    }

    protected void assertExceptionMessage(Exception e, String message) {
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{message});
    }
}

