/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskQueryDisabledAdhocExpressionsTest
extends PluggableProcessEngineTest {
    protected static final String EXPECTED_ADHOC_QUERY_FAILURE_MESSAGE = "Expressions are forbidden in adhoc queries. This behavior can be toggled in the process engine configuration";
    public static final String STATE_MANIPULATING_EXPRESSION = "${''.getClass().forName('" + TaskQueryDisabledAdhocExpressionsTest.class.getName() + "').getField('MUTABLE_FIELD').setLong(null, 42)}";
    public static long MUTABLE_FIELD = 0L;

    @Test
    public void testDefaultSetting() {
        Assert.assertTrue((boolean)this.processEngineConfiguration.isEnableExpressionsInStoredQueries());
        Assert.assertFalse((boolean)this.processEngineConfiguration.isEnableExpressionsInAdhocQueries());
    }

    @Before
    public void setUp() throws Exception {
        MUTABLE_FIELD = 0L;
    }

    @Test
    public void testAdhocExpressionsFail() {
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().dueBeforeExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().dueDateExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().followUpAfterExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().followUpBeforeExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().followUpBeforeOrNotExistentExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().followUpDateExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskAssigneeExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskAssigneeLikeExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskCandidateGroupExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskCandidateGroupInExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskCandidateUserExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskCreatedAfterExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskCreatedBeforeExpression(STATE_MANIPULATING_EXPRESSION));
        this.executeAndValidateFailingQuery(this.taskService.createTaskQuery().taskOwnerExpression(STATE_MANIPULATING_EXPRESSION));
    }

    @Test
    public void testExtendStoredFilterByExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfterExpression("${now()}");
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        Assert.assertEquals((Object)new Long(0L), (Object)this.filterService.count(filter.getId()));
        Assert.assertEquals((long)0L, (long)this.filterService.list(filter.getId()).size());
        this.extendFilterAndValidateFailingQuery(filter, this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION));
        this.filterService.deleteFilter(filter.getId());
    }

    @Test
    public void testExtendStoredFilterByScalar() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfterExpression("${now()}");
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        Assert.assertEquals((Object)new Long(0L), (Object)this.filterService.count(filter.getId()));
        Assert.assertEquals((long)0L, (long)this.filterService.list(filter.getId()).size());
        Assert.assertEquals((Object)new Long(0L), (Object)this.filterService.count(filter.getId(), (Query)this.taskService.createTaskQuery().dueAfter(new Date())));
        Assert.assertEquals((long)0L, (long)this.filterService.list(filter.getId(), (Query)this.taskService.createTaskQuery().dueAfter(new Date())).size());
        this.filterService.deleteFilter(filter.getId());
    }

    protected boolean fieldIsUnchanged() {
        return MUTABLE_FIELD == 0L;
    }

    protected void executeAndValidateFailingQuery(TaskQuery query) {
        try {
            query.list();
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_ADHOC_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
        try {
            query.count();
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_ADHOC_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
    }

    protected void extendFilterAndValidateFailingQuery(Filter filter, TaskQuery query) {
        try {
            this.filterService.list(filter.getId(), (Query)query);
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_ADHOC_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
        try {
            this.filterService.count(filter.getId(), (Query)query);
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_ADHOC_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
    }
}

