/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConditionalEventTriggeredByExecutionListenerTest
extends AbstractConditionalEventTestCase {
    protected static final String TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT = "Task after conditional boundary event";
    protected static final String TASK_AFTER_CONDITIONAL_START_EVENT = "Task after conditional start event";
    protected static final String START_EVENT_ID = "startEventId";
    protected static final String END_EVENT_ID = "endEventId";
    @Parameterized.Parameter
    public ConditionalEventProcessSpecifier specifier;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new ConditionalEventProcessSpecifier(){

            @Override
            public BpmnModelInstance specifyConditionalProcess(BpmnModelInstance modelInstance, boolean isInterrupting) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(isInterrupting)).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            @Override
            public void assertTaskNames(List<Task> tasks, boolean isInterrupting, boolean isAyncBefore) {
                if (isInterrupting || isAyncBefore) {
                    ConditionalEventTriggeredByExecutionListenerTest.assertTaskNames(tasks, "After Condition");
                } else {
                    ConditionalEventTriggeredByExecutionListenerTest.assertTaskNames(tasks, "Task with condition", "After Condition");
                }
            }

            @Override
            public int expectedSubscriptions() {
                return 1;
            }

            @Override
            public int expectedTaskCount() {
                return 2;
            }

            public String toString() {
                return "ConditionalEventSubProcess";
            }
        }}, {new ConditionalEventProcessSpecifier(){

            @Override
            public BpmnModelInstance specifyConditionalProcess(BpmnModelInstance modelInstance, boolean isInterrupting) {
                modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(isInterrupting)).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name(ConditionalEventTriggeredByExecutionListenerTest.TASK_AFTER_CONDITIONAL_START_EVENT)).endEvent().done();
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(modelInstance).activityBuilder("taskWithCondition").boundaryEvent().cancelActivity(Boolean.valueOf(isInterrupting))).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name(ConditionalEventTriggeredByExecutionListenerTest.TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT)).endEvent().done();
            }

            @Override
            public void assertTaskNames(List<Task> tasks, boolean isInterrupting, boolean isAyncBefore) {
                Assert.assertNotNull(tasks);
                if (isInterrupting || isAyncBefore) {
                    ConditionalEventTriggeredByExecutionListenerTest.assertTaskNames(tasks, ConditionalEventTriggeredByExecutionListenerTest.TASK_AFTER_CONDITIONAL_START_EVENT);
                } else {
                    ConditionalEventTriggeredByExecutionListenerTest.assertTaskNames(tasks, "Task with condition", ConditionalEventTriggeredByExecutionListenerTest.TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, ConditionalEventTriggeredByExecutionListenerTest.TASK_AFTER_CONDITIONAL_START_EVENT);
                }
            }

            @Override
            public int expectedSubscriptions() {
                return 2;
            }

            @Override
            public int expectedTaskCount() {
                return 3;
            }

            public String toString() {
                return "MixedConditionalProcess";
            }
        }});
    }

    @Test
    public void testSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.expectedTaskCount(), (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)this.specifier.expectedSubscriptions(), (long)this.conditionEventSubscriptionQuery.list().size());
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    @Test
    public void testSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.expectedTaskCount(), (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)this.specifier.expectedSubscriptions(), (long)this.conditionEventSubscriptionQuery.list().size());
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    @Test
    public void testSetVariableInTakeListenerWithAsyncBefore() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).camundaAsyncBefore()).endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableInTakeListenerWithAsyncBefore() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).camundaAsyncBefore()).endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.specifier.assertTaskNames(taskQuery.list(), false, true);
        Job job = (Job)this.engine.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.engine.getManagementService().executeJob(job.getId());
        for (Task task : taskQuery.list()) {
            this.taskService.complete(task.getId());
        }
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).userTask("taskWithCondition").name("Task with condition")).endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).userTask("taskWithCondition").name("Task with condition")).endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)this.specifier.expectedTaskCount(), (long)this.tasksAfterVariableIsSet.size());
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    @Test
    public void testSetVariableOnParentScopeInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.getParent().setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableOnParentScopeInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.getParent().setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    @Test
    public void testSetVariableOnParentScopeInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("start", "${execution.getParent().setVariable(\"variable\", 1)}")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableOnParentScopeInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("start", "${execution.getParent().setVariable(\"variable\", 1)}")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    @Test
    public void testSetVariableOnParentScopeInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerExpression("end", "${execution.getParent().setVariable(\"variable\", 1)}")).userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, true);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, true, false);
    }

    @Test
    public void testNonInterruptingSetVariableOnParentScopeInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent(START_EVENT_ID).subProcess().embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).camundaExecutionListenerExpression("end", "${execution.getParent().setVariable(\"variable\", 1)}")).userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent(END_EVENT_ID).done();
        modelInstance = this.specifier.specifyConditionalProcess(modelInstance, false);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        this.specifier.assertTaskNames(this.tasksAfterVariableIsSet, false, false);
    }

    private static interface ConditionalEventProcessSpecifier {
        public BpmnModelInstance specifyConditionalProcess(BpmnModelInstance var1, boolean var2);

        public void assertTaskNames(List<Task> var1, boolean var2, boolean var3);

        public int expectedSubscriptions();

        public int expectedTaskCount();
    }
}

