/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.entity;

import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceEntity;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Test;

public class CaseDefinitionIdHistoryUpdateTest
extends PluggableProcessEngineTest {
    @RequiredHistoryLevel(value="activity")
    @Test
    public void testUpdateCaseDefinitionIdInCaseExecutionEntity() {
        CaseDefinitionEntity caseDefinitionEntity1 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        CaseDefinitionEntity caseDefinitionEntity2 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        CaseExecutionEntity caseExecutionEntity = this.prepareCaseExecution(caseDefinitionEntity1);
        Assertions.assertThat((String)caseExecutionEntity.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity1.getId());
        this.createCaseExecution(caseExecutionEntity);
        caseExecutionEntity.setCaseDefinition((CmmnCaseDefinition)caseDefinitionEntity2);
        HistoricCaseActivityInstanceEventEntity historicCaseActivityInstanceEntity = this.prepareHistoricCaseActivityInstance(caseDefinitionEntity1);
        this.createCaseExecutionHistory(historicCaseActivityInstanceEntity);
        historicCaseActivityInstanceEntity.setCaseDefinitionId(caseDefinitionEntity2.getId());
        historicCaseActivityInstanceEntity.setEventType(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE.getEventName());
        this.updateCaseExecutionHistory(historicCaseActivityInstanceEntity);
        HistoricCaseActivityInstanceEntity updatedInstance = this.findHistoricCaseActivityInstance(historicCaseActivityInstanceEntity.getId());
        Assertions.assertThat((String)updatedInstance.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity2.getId());
        this.deleteHistoricCaseActivityInstance(historicCaseActivityInstanceEntity);
        this.deleteCaseExecution(caseExecutionEntity);
        this.deleteCaseDefinition(caseDefinitionEntity1);
        this.deleteCaseDefinition(caseDefinitionEntity2);
    }

    private HistoricCaseActivityInstanceEventEntity prepareHistoricCaseActivityInstance(CaseDefinitionEntity caseDefinitionEntity1) {
        HistoricCaseActivityInstanceEventEntity historicCaseActivityInstanceEntity = new HistoricCaseActivityInstanceEventEntity();
        historicCaseActivityInstanceEntity.setId(UUID.randomUUID().toString());
        historicCaseActivityInstanceEntity.setCaseDefinitionId(caseDefinitionEntity1.getId());
        historicCaseActivityInstanceEntity.setCaseInstanceId(UUID.randomUUID().toString());
        historicCaseActivityInstanceEntity.setCaseActivityId(UUID.randomUUID().toString());
        historicCaseActivityInstanceEntity.setCreateTime(new Date());
        return historicCaseActivityInstanceEntity;
    }

    private CaseExecutionEntity prepareCaseExecution(CaseDefinitionEntity caseDefinitionEntity1) {
        CaseExecutionEntity caseExecutionEntity = new CaseExecutionEntity();
        caseExecutionEntity.setId(UUID.randomUUID().toString());
        caseExecutionEntity.setCaseDefinition((CmmnCaseDefinition)caseDefinitionEntity1);
        return caseExecutionEntity;
    }

    private CaseDefinitionEntity prepareCaseDefinition(String id) {
        CaseDefinitionEntity caseDefinitionEntity = new CaseDefinitionEntity();
        caseDefinitionEntity.setId(id);
        caseDefinitionEntity.setKey(UUID.randomUUID().toString());
        caseDefinitionEntity.setDeploymentId(UUID.randomUUID().toString());
        this.createCaseDefinition(caseDefinitionEntity);
        return caseDefinitionEntity;
    }

    private Void createCaseExecutionHistory(final HistoricCaseActivityInstanceEventEntity historicCaseActivityInstanceEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getDbEntityManager().insert((DbEntity)historicCaseActivityInstanceEntity);
                return null;
            }
        });
    }

    private Void updateCaseExecutionHistory(final HistoricCaseActivityInstanceEventEntity historicCaseActivityInstanceEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getDbEntityManager().merge((DbEntity)historicCaseActivityInstanceEntity);
                return null;
            }
        });
    }

    private HistoricCaseActivityInstanceEntity findHistoricCaseActivityInstance(final String id) {
        return (HistoricCaseActivityInstanceEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<HistoricCaseActivityInstanceEntity>(){

            public HistoricCaseActivityInstanceEntity execute(CommandContext commandContext) {
                return (HistoricCaseActivityInstanceEntity)commandContext.getDbEntityManager().selectOne("selectHistoricCaseActivityInstance", (Object)id);
            }
        });
    }

    private Void deleteCaseExecution(final CaseExecutionEntity caseExecutionEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().deleteCaseExecution(caseExecutionEntity);
                return null;
            }
        });
    }

    private void createCaseExecution(final CaseExecutionEntity caseExecutionEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().insertCaseExecution(caseExecutionEntity);
                return null;
            }
        });
    }

    private void createCaseDefinition(final CaseDefinitionEntity caseDefinitionEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseDefinitionManager().insertCaseDefinition(caseDefinitionEntity);
                return null;
            }
        });
    }

    private Void deleteCaseDefinition(final CaseDefinitionEntity caseDefinitionEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseDefinitionManager().deleteCaseDefinitionsByDeploymentId(caseDefinitionEntity.getDeploymentId());
                return null;
            }
        });
    }

    private Void deleteHistoricCaseActivityInstance(final HistoricCaseActivityInstanceEventEntity entity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricCaseActivityInstanceManager().deleteHistoricCaseActivityInstancesByCaseInstanceIds(Collections.singletonList(entity.getCaseInstanceId()));
                return null;
            }
        });
    }
}

