/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.tree;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;

public class ActivityExecutionMappingCollector
implements TreeVisitor<ActivityExecution> {
    private final Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
    private final ActivityExecution initialExecution;
    private boolean initialized = false;

    public ActivityExecutionMappingCollector(ActivityExecution execution) {
        this.initialExecution = execution;
    }

    @Override
    public void visit(ActivityExecution execution) {
        if (!this.initialized) {
            this.appendActivityExecutionMapping(this.initialExecution);
            this.initialized = true;
        }
        this.appendActivityExecutionMapping(execution);
    }

    private void appendActivityExecutionMapping(ActivityExecution execution) {
        if (execution.getActivity() != null && !LegacyBehavior.hasInvalidIntermediaryActivityId((PvmExecutionImpl)execution)) {
            this.activityExecutionMapping.putAll(execution.createActivityExecutionMapping());
        }
    }

    public PvmExecutionImpl getExecutionForScope(PvmScope scope) {
        return this.activityExecutionMapping.get(scope);
    }
}

