/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActivityStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml");
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        try {
            this.managementService.createActivityStatisticsQuery(processDefinitionId).list();
            Assert.fail((String)"Exception expected: It should not be possible to execute the activity statistics query");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_INCIDENT_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testQueryIncludingInstancesWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processDefinitionId);
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryIncludingInstancesWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingInstancesWithMany() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingInstancesWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingInstancesWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingFailedJobsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        Assert.assertNull((Object)statistics);
    }

    @Test
    public void testQueryIncludingFailedJobsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)1L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingFailedJobsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)3L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)3L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryIncludingIncidentsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        Assert.assertNull((Object)statistics);
    }

    @Test
    public void testQueryIncludingIncidentsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testQueryIncludingIncidentsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)3L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testQueryIncludingIncidentsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)3L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testQueryIncludingIncidentsAndFailedJobsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        Assert.assertNull((Object)statistics);
    }

    @Test
    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)1L, (long)statistics.getInstances());
        Assert.assertEquals((long)1L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)3L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)3L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testQueryIncludingIncidentsAndFailedJobsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((Object)"scriptTask", (Object)statistics.getId());
        Assert.assertEquals((long)3L, (long)statistics.getInstances());
        Assert.assertEquals((long)3L, (long)statistics.getFailedJobs());
        Assert.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        Assert.assertEquals((long)3L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testManyAuthorizationsActivityStatisticsQueryIncludingFailedJobsAndIncidents() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"scriptTask", (Object)activityResult.getId());
        Assert.assertEquals((long)3L, (long)activityResult.getFailedJobs());
        Assert.assertFalse((boolean)activityResult.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)activityResult.getIncidentStatistics().get(0);
        Assert.assertEquals((long)3L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    public void testManyAuthorizationsActivityStatisticsQuery() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createActivityStatisticsQuery(processDefinitionId).list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)3L, (long)activityResult.getInstances());
        Assert.assertEquals((Object)"scriptTask", (Object)activityResult.getId());
        Assert.assertEquals((long)0L, (long)activityResult.getFailedJobs());
        Assert.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    protected void verifyQueryResults(ActivityStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

