/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StandaloneTaskGetVariableAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected RuntimeService runtimeService;
    protected static final String userId = "userId";
    protected String taskId = "myTask";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected boolean ensureSpecificVariablePermission;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.READ_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.READ_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", userId, new Permission[]{TaskPermissions.READ_VARIABLE})).succeeds());
    }

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authRule.createUserAndGroup(userId, "groupId");
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.taskService.deleteTask(this.taskId, true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    @Test
    public void testGetVariable() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Object variable = this.taskService.getVariable(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variable);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariableLocal() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Object variable = this.taskService.getVariableLocal(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variable);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariableTyped() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        TypedValue typedValue = this.taskService.getVariableTyped(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)typedValue);
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)typedValue.getValue());
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariableLocalTyped() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)typedValue);
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)typedValue.getValue());
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariables() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Map variables = this.taskService.getVariables(this.taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesLocal() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Map variables = this.taskService.getVariablesLocal(this.taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesTyped() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        VariableMap variables = this.taskService.getVariablesTyped(this.taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesLocalTyped() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        VariableMap variables = this.taskService.getVariablesLocalTyped(this.taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesByName() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Map variables = this.taskService.getVariables(this.taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesLocalByName() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        Map variables = this.taskService.getVariablesLocal(this.taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesTypedByName() {
        this.createTask(this.taskId);
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        VariableMap variables = this.taskService.getVariablesTyped(this.taskId, Arrays.asList(VARIABLE_NAME), false);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
            this.deleteAuthorizations();
        }
    }

    @Test
    public void testGetVariablesLocalTypedByName() {
        this.createTask(this.taskId);
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        VariableMap variables = this.taskService.getVariablesLocalTyped(this.taskId, Arrays.asList(VARIABLE_NAME), false);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
            this.deleteAuthorizations();
        }
    }

    protected void createTask(String taskId) {
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }

    protected void deleteAuthorizations() {
        AuthorizationService authorizationService = this.engineRule.getAuthorizationService();
        for (Authorization authorization : authorizationService.createAuthorizationQuery().list()) {
            authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        Assert.assertNotNull(variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variables.get(VARIABLE_NAME));
    }
}

