/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDetailAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(false);
    }

    @Test
    public void testQueryAfterStandaloneTaskVariableUpdates() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSimpleVariableUpdateQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleVariableUpdateQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleVariableUpdateQueryMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleVariableUpdateQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testVariableUpdateQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testVariableUpdateQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testVariableUpdateQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryAfterCaseVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testMixedQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testSimpleFormFieldQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleFormFieldQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleFormFieldQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testFormFieldQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testFormFieldQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testFormFieldQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().formFields();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testDetailQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testDetailQueryWithReadHistoryOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testDetailQueryWithReadHistoryOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY);
        taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.formService.submitTaskForm(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        this.verifyQueryResults(query, 7);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testOnlyReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIgnoreReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(false);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadVariablePermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryVariablePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadHistoryVariablePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testOnlyReadPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIgnoreReadHistoryVariablePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(false);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        List result = this.historyService.createHistoricDetailQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance_GlobalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance_LocalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    protected void verifyQueryResults(HistoricDetailQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

