/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_PROCESS_KEY = "demoAssigneeProcess";
    protected static final String CASE_KEY = "oneTaskCase";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/authorization/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void testQueryForStandaloneTaskHistoricIdentityLinkWithoutAuthrorization() {
        this.disableAuthorization();
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.disableAuthorization();
        this.taskService.deleteTask("newTask", true);
        this.enableAuthorization();
    }

    @Test
    public void testQueryForTaskHistoricIdentityLinkWithoutUserPermission() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryForTaskHistoricIdentityLinkWithUserPermission() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithMultiple() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryCaseTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testMixedQuery() {
        this.disableAuthorization();
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.taskService.addCandidateUser(((Task)this.taskService.createTaskQuery().list().get(3)).getId(), "dUserId");
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.taskService.addCandidateUser(((Task)this.taskService.createTaskQuery().list().get(4)).getId(), "eUserId");
        this.createTaskAndAssignUser("one");
        this.createTaskAndAssignUser("two");
        this.createTaskAndAssignUser("three");
        this.createTaskAndAssignUser("four");
        this.createTaskAndAssignUser("five");
        this.enableAuthorization();
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
        this.disableAuthorization();
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 10);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.enableAuthorization();
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(ONE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        List result = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((List)query.list()).extracting("rootProcessInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((List)query.list()).extracting("rootProcessInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((List)query.list()).extracting("rootProcessInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(ONE_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((List)query.list()).extracting("rootProcessInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void createTaskAndAssignUser(String taskId) {
        Task task = this.taskService.newTask(taskId);
        task.setAssignee("demo");
        this.taskService.saveTask(task);
    }
}

