/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IdentityServiceTenantTest {
    protected static final String USER_ONE = "user1";
    protected static final String USER_TWO = "user2";
    protected static final String GROUP_ONE = "group1";
    protected static final String GROUP_TWO = "group2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    private final String INVALID_ID_MESSAGE = "%s has an invalid id: '%s' is not a valid resource identifier.";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected IdentityService identityService;
    protected ProcessEngine processEngine;

    @Before
    public void initService() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        this.identityService.deleteTenant(TENANT_ONE);
        this.identityService.deleteTenant(TENANT_TWO);
        this.identityService.deleteGroup(GROUP_ONE);
        this.identityService.deleteGroup(GROUP_TWO);
        this.identityService.deleteUser(USER_ONE);
        this.identityService.deleteUser(USER_TWO);
        if (this.processEngine != null) {
            for (Tenant deleteTenant : this.processEngine.getIdentityService().createTenantQuery().list()) {
                this.processEngine.getIdentityService().deleteTenant(deleteTenant.getId());
            }
            for (Authorization authorization : this.processEngine.getAuthorizationService().createAuthorizationQuery().list()) {
                this.processEngine.getAuthorizationService().deleteAuthorization(authorization.getId());
            }
            this.processEngine.close();
            ProcessEngines.unregister((ProcessEngine)this.processEngine);
            this.processEngine = null;
        }
    }

    @Test
    public void createTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        tenant.setName("Tenant");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assertions.assertThat((Object)tenant).isNotNull();
        Assertions.assertThat((String)tenant.getId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)tenant.getName()).isEqualTo((Object)"Tenant");
    }

    @Test
    public void createExistingTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        tenant.setName("Tenant");
        this.identityService.saveTenant(tenant);
        Tenant secondTenant = this.identityService.newTenant(TENANT_ONE);
        secondTenant.setName("Tenant");
        try {
            this.identityService.saveTenant(secondTenant);
            Assert.fail((String)"BadUserRequestException is expected");
        }
        catch (Exception ex) {
            if (!(ex instanceof BadUserRequestException)) {
                Assert.fail((String)("BadUserRequestException is expected, but another exception was received:  " + ex));
            }
            Assert.assertEquals((Object)"The tenant already exists", (Object)ex.getMessage());
        }
    }

    @Test
    public void updateTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        tenant.setName("Tenant");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assertions.assertThat((Object)tenant).isNotNull();
        tenant.setName("newName");
        this.identityService.saveTenant(tenant);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        Assert.assertEquals((Object)"newName", (Object)tenant.getName());
    }

    @Test
    public void testInvalidTenantId() {
        String invalidId = "john's tenant";
        Tenant tenant = this.identityService.newTenant(invalidId);
        try {
            this.identityService.saveTenant(tenant);
            Assert.fail((String)"Invalid tenant id exception expected!");
        }
        catch (ProcessEngineException ex) {
            Assert.assertEquals((Object)String.format("%s has an invalid id: '%s' is not a valid resource identifier.", "Tenant", invalidId), (Object)ex.getMessage());
        }
    }

    @Test
    public void testInvalidTenantIdOnUpdate() {
        String invalidId = "john's tenant";
        try {
            Tenant updatedTenant = this.identityService.newTenant("john");
            updatedTenant.setId(invalidId);
            this.identityService.saveTenant(updatedTenant);
            Assert.fail((String)"Invalid tenant id exception expected!");
        }
        catch (ProcessEngineException ex) {
            Assert.assertEquals((Object)String.format("%s has an invalid id: '%s' is not a valid resource identifier.", "Tenant", invalidId), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCustomCreateTenantWhitelistPattern() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/api/identity/generic.resource.id.whitelist.camunda.cfg.xml").buildProcessEngine();
        this.processEngine.getProcessEngineConfiguration().setTenantResourceWhitelistPattern("[a-zA-Z]+");
        String invalidId = "john's tenant";
        Tenant tenant = this.processEngine.getIdentityService().newTenant(invalidId);
        try {
            this.processEngine.getIdentityService().saveTenant(tenant);
            Assert.fail((String)"Invalid tenant id exception expected!");
        }
        catch (ProcessEngineException ex) {
            Assert.assertEquals((Object)String.format("%s has an invalid id: '%s' is not a valid resource identifier.", "Tenant", invalidId), (Object)ex.getMessage());
        }
    }

    @Test
    public void testCustomTenantWhitelistPattern() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/api/identity/generic.resource.id.whitelist.camunda.cfg.xml").buildProcessEngine();
        this.processEngine.getProcessEngineConfiguration().setTenantResourceWhitelistPattern("[a-zA-Z]+");
        String validId = "johnsTenant";
        String invalidId = "john!@#$%";
        try {
            Tenant tenant = this.processEngine.getIdentityService().newTenant(validId);
            tenant.setId(invalidId);
            this.processEngine.getIdentityService().saveTenant(tenant);
            Assert.fail((String)"Invalid tenant id exception expected!");
        }
        catch (ProcessEngineException ex) {
            Assert.assertEquals((Object)String.format("%s has an invalid id: '%s' is not a valid resource identifier.", "Tenant", invalidId), (Object)ex.getMessage());
        }
    }

    @Test
    public void deleteTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenant("nonExisting");
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenant(TENANT_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void updateTenantOptimisticLockingException() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Tenant tenant1 = (Tenant)this.identityService.createTenantQuery().singleResult();
        Tenant tenant2 = (Tenant)this.identityService.createTenantQuery().singleResult();
        tenant1.setName("name");
        this.identityService.saveTenant(tenant1);
        tenant2.setName("other name");
        Assertions.assertThatThrownBy(() -> this.identityService.saveTenant(tenant2)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void createTenantWithGenericResourceId() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/api/identity/generic.resource.id.whitelist.camunda.cfg.xml").buildProcessEngine();
        Tenant tenant = this.processEngine.getIdentityService().newTenant("*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngine.getIdentityService().saveTenant(tenant)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("has an invalid id: id cannot be *. * is a reserved identifier.");
    }

    @Test
    public void createTenantMembershipUnexistingTenant() {
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createTenantUserMembership("nonExisting", user.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No tenant found with id 'nonExisting'.");
    }

    @Test
    public void createTenantMembershipUnexistingUser() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createTenantUserMembership(tenant.getId(), "nonExisting")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No user found with id 'nonExisting'.");
    }

    @Test
    public void createTenantMembershipUnexistingGroup() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createTenantGroupMembership(tenant.getId(), "nonExisting")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No group found with id 'nonExisting'.");
    }

    @Test
    public void createTenantUserMembershipAlreadyExisting() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        Assertions.assertThatThrownBy(() -> this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void createTenantGroupMembershipAlreadyExisting() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        Assertions.assertThatThrownBy(() -> this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void deleteTenantUserMembership() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantUserMembership("nonExisting", USER_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantUserMembership(TENANT_ONE, "nonExisting");
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantUserMembership(TENANT_ONE, USER_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteTenantGroupMembership() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        TenantQuery query = this.identityService.createTenantQuery().groupMember(GROUP_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantGroupMembership("nonExisting", GROUP_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, "nonExisting");
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteTenantMembershipsWileDeleteUser() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteUser(USER_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteTenantMembershipsWhileDeleteGroup() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        TenantQuery query = this.identityService.createTenantQuery().groupMember(GROUP_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.identityService.deleteGroup(GROUP_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteTenantMembershipsOfTenant() {
        Tenant tenant = this.identityService.newTenant(TENANT_ONE);
        this.identityService.saveTenant(tenant);
        User user = this.identityService.newUser(USER_ONE);
        this.identityService.saveUser(user);
        Group group = this.identityService.newGroup(GROUP_ONE);
        this.identityService.saveGroup(group);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ONE);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ONE);
        UserQuery userQuery = this.identityService.createUserQuery().memberOfTenant(TENANT_ONE);
        GroupQuery groupQuery = this.identityService.createGroupQuery().memberOfTenant(TENANT_ONE);
        Assertions.assertThat((long)userQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)groupQuery.count()).isEqualTo(1L);
        this.identityService.deleteTenant(TENANT_ONE);
        Assertions.assertThat((long)userQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)groupQuery.count()).isEqualTo(0L);
    }
}

