/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessDefinitionStatisticsQueryTest
extends PluggableProcessEngineTest {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidents() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithInvalidIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("invalid").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsAndFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithoutRunningInstances() {
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryCount() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.testRule.executeAvailableJobs();
        long count = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().count();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testMultiInstanceProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testSubprocessStatisticsQuery.bpmn20.xml"})
    public void testSubprocessProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testCallActivityProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            if (result.getKey().equals("ExampleProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)1L, (long)result.getFailedJobs());
                continue;
            }
            if (result.getKey().equals("callExampleSubProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)0L, (long)result.getFailedJobs());
                continue;
            }
            Assert.fail((String)(result + " was not expected."));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersions() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithFailedJobsAndIncidents() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId(), parameters);
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        List incidentStatistics = definitionResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        incidentStatistics = definitionResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithIncidentType() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryPagination() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsWithoutFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics callExampleSubProcessStaticstics = null;
        ProcessDefinitionStatistics exampleSubProcessStaticstics = null;
        for (ProcessDefinitionStatistics current : statistics) {
            if (current.getKey().equals("callExampleSubProcess")) {
                callExampleSubProcessStaticstics = current;
                continue;
            }
            if (current.getKey().equals("ExampleProcess")) {
                exampleSubProcessStaticstics = current;
                continue;
            }
            Assert.fail((String)(current.getKey() + " was not expected."));
        }
        Assert.assertNotNull(callExampleSubProcessStaticstics);
        Assert.assertNotNull(exampleSubProcessStaticstics);
        Assert.assertEquals((long)1L, (long)callExampleSubProcessStaticstics.getInstances());
        Assert.assertEquals((long)0L, (long)callExampleSubProcessStaticstics.getFailedJobs());
        Assert.assertFalse((boolean)callExampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)callExampleSubProcessStaticstics.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)callExampleSubProcessStaticstics.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getInstances());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getFailedJobs());
        Assert.assertFalse((boolean)exampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getIncidentStatistics().size());
        incidentStatistics = (IncidentStatistics)exampleSubProcessStaticstics.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentTypeWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsAndIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testIncludeRootIncidentsOnly() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeRootIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ProcessDefinitionStatistics definitionResult : statistics) {
            if (definitionResult.getKey().equals("callExampleSubProcess")) {
                Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
                continue;
            }
            if (definitionResult.getKey().equals("ExampleProcess")) {
                Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
                Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
                Assert.assertEquals((long)1L, (long)((IncidentStatistics)definitionResult.getIncidentStatistics().get(0)).getIncidentCount());
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testIncludeRootIncidentsFails() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        try {
            this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeRootIncidents().list();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"It is not possible to use includeIncident() and includeRootIncidents() to execute one query"});
        }
    }

    @Test
    public void testProcessDefinitionStatisticsProperties() {
        String resourceName = "org/camunda/bpm/engine/test/api/mgmt/ProcessDefinitionStatisticsQueryTest.testProcessDefinitionStatisticsProperties.bpmn20.xml";
        String deploymentId = this.testRule.deployForTenant("tenant1", resourceName).getId();
        ProcessDefinitionStatistics processDefinitionStatistics = (ProcessDefinitionStatistics)this.managementService.createProcessDefinitionStatisticsQuery().singleResult();
        Assert.assertEquals((Object)"testProcess", (Object)processDefinitionStatistics.getKey());
        Assert.assertEquals((Object)"process name", (Object)processDefinitionStatistics.getName());
        Assert.assertEquals((Object)"Examples", (Object)processDefinitionStatistics.getCategory());
        Assert.assertEquals(null, (Object)processDefinitionStatistics.getDescription());
        Assert.assertEquals((Object)"tenant1", (Object)processDefinitionStatistics.getTenantId());
        Assert.assertEquals((Object)"v0.1.0", (Object)processDefinitionStatistics.getVersionTag());
        Assert.assertEquals((Object)deploymentId, (Object)processDefinitionStatistics.getDeploymentId());
        Assert.assertEquals((Object)resourceName, (Object)processDefinitionStatistics.getResourceName());
        Assert.assertEquals(null, (Object)processDefinitionStatistics.getDiagramResourceName());
        Assert.assertEquals((long)1L, (long)processDefinitionStatistics.getVersion());
        Assert.assertEquals((long)0L, (long)processDefinitionStatistics.getInstances());
        Assert.assertEquals((long)0L, (long)processDefinitionStatistics.getFailedJobs());
        Assert.assertTrue((boolean)processDefinitionStatistics.getIncidentStatistics().isEmpty());
    }
}

