/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MetricsDisabledTest {
    @ClassRule
    public static final ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/api/mgmt/metrics/metricsDisabledTest.cfg.xml");
    protected final ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected final ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ManagementService managementService;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
    }

    @Ignore(value="CAM-4053")
    @Test
    public void testQueryMetricsIfMetricsIsDisabled() {
        Assert.assertFalse((boolean)this.processEngineConfiguration.isMetricsEnabled());
        Assert.assertFalse((boolean)this.processEngineConfiguration.isDbMetricsReporterActivate());
        this.managementService.createMetricsQuery().sum();
    }

    @Test
    public void testReportNowIfMetricsDisabled() {
        Assert.assertFalse((boolean)this.processEngineConfiguration.isDbMetricsReporterActivate());
        try {
            this.managementService.reportDbMetricsNow();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Metrics reporting is disabled", e.getMessage());
        }
    }
}

