/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySharedProcessDefinitionStatisticsQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String ONE_TASK_PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final String FAILED_JOBS_PROCESS_DEFINITION_KEY = "ExampleProcess";
    protected static StaticTenantIdTestProvider tenantIdProvider;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain tenantRuleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected static final BpmnModelInstance oneTaskProcess;
    protected static final BpmnModelInstance failingProcess;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void activeProcessInstancesCountWithNoAuthenticatedTenant() {
        this.testRule.deploy(oneTaskProcess);
        this.startProcessInstances(ONE_TASK_PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)1L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getInstances());
    }

    @Test
    public void activeProcessInstancesCountWithAuthenticatedTenant() {
        this.testRule.deploy(oneTaskProcess);
        this.startProcessInstances(ONE_TASK_PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)2L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getInstances());
    }

    @Test
    public void activeProcessInstancesCountWithDisabledTenantCheck() {
        this.testRule.deploy(oneTaskProcess);
        this.startProcessInstances(ONE_TASK_PROCESS_DEFINITION_KEY);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)3L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getInstances());
    }

    @Test
    public void activeProcessInstancesCountWithMultipleAuthenticatedTenants() {
        this.testRule.deploy(oneTaskProcess);
        this.startProcessInstances(ONE_TASK_PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)3L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getInstances());
    }

    @Test
    public void failedJobsCountWithWithNoAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)1L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getFailedJobs());
    }

    @Test
    public void failedJobsCountWithWithDisabledTenantCheck() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)3L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getFailedJobs());
    }

    @Test
    public void failedJobsCountWithAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)2L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getFailedJobs());
    }

    @Test
    public void failedJobsCountWithMultipleAuthenticatedTenants() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        Assert.assertEquals((long)3L, (long)((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getFailedJobs());
    }

    @Test
    public void incidentsCountWithNoAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        List incidentStatistics = ((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)1L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    @Test
    public void incidentsCountWithDisabledTenantCheck() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        List incidentStatistics = ((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)3L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    @Test
    public void incidentsCountWithAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        List incidentStatistics = ((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)2L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    @Test
    public void incidentsCountWithMultipleAuthenticatedTenants() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        List incidentStatistics = ((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)3L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    @Test
    public void incidentsCountWithIncidentTypeAndAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        List incidentStatistics = ((ProcessDefinitionStatistics)processDefinitionsStatistics.get(0)).getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)2L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    @Test
    public void instancesFailedJobsAndIncidentsCountWithAuthenticatedTenant() {
        this.testRule.deploy(failingProcess);
        this.startProcessInstances(FAILED_JOBS_PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List processDefinitionsStatistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)processDefinitionsStatistics.size());
        ProcessDefinitionStatistics processDefinitionStatistics = (ProcessDefinitionStatistics)processDefinitionsStatistics.get(0);
        Assert.assertEquals((long)2L, (long)processDefinitionStatistics.getInstances());
        Assert.assertEquals((long)2L, (long)processDefinitionStatistics.getFailedJobs());
        List incidentStatistics = processDefinitionStatistics.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        Assert.assertEquals((long)2L, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
    }

    protected void startProcessInstances(String key) {
        this.setTenantIdProvider(null);
        this.runtimeService.startProcessInstanceByKey(key);
        this.setTenantIdProvider(TENANT_ONE);
        this.runtimeService.startProcessInstanceByKey(key);
        this.setTenantIdProvider(TENANT_TWO);
        this.runtimeService.startProcessInstanceByKey(key);
    }

    protected void setTenantIdProvider(String tenantId) {
        tenantIdProvider.setTenantIdProvider(tenantId);
    }

    static {
        bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
            tenantIdProvider = new StaticTenantIdTestProvider(TENANT_ONE);
            configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
        });
        oneTaskProcess = Bpmn.createExecutableProcess((String)ONE_TASK_PROCESS_DEFINITION_KEY).startEvent().userTask().done();
        failingProcess = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)FAILED_JOBS_PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaClass("org.camunda.bpm.engine.test.api.multitenancy.FailingDelegate")).camundaAsyncBefore()).done();
    }
}

