/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDeploymentCmdsTenantCheckTest {
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().startEvent().done();
    protected static final BpmnModelInstance startEndProcess = Bpmn.createExecutableProcess().startEvent().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void createDeploymentForAnotherTenant() {
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void createDeploymentWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void createDeploymentDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.createDeployment().addModelInstance("emptyProcessOne", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.repositoryService.createDeployment().addModelInstance("emptyProcessTwo", startEndProcess).tenantId(TENANT_TWO).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void failToDeleteDeploymentNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteDeployment(deployment.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the deployment");
    }

    @Test
    public void deleteDeploymentWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteDeployment(deployment.getId());
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
    }

    @Test
    public void deleteDeploymentDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteDeployment(deploymentOne.getId());
        this.repositoryService.deleteDeployment(deploymentTwo.getId());
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void failToGetDeploymentResourceNamesNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDeploymentResourceNames(deployment.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the deployment");
    }

    @Test
    public void getDeploymentResourceNamesWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deployment.getId());
        Assertions.assertThat((List)deploymentResourceNames).hasSize(1);
    }

    @Test
    public void getDeploymentResourceNamesDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deploymentOne.getId());
        Assertions.assertThat((List)deploymentResourceNames).hasSize(1);
        deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deploymentTwo.getId());
        Assertions.assertThat((List)deploymentResourceNames).hasSize(1);
    }

    @Test
    public void failToGetDeploymentResourcesNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDeploymentResources(deployment.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the deployment");
    }

    @Test
    public void getDeploymentResourcesWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        Assertions.assertThat((List)deploymentResources).hasSize(1);
    }

    @Test
    public void getDeploymentResourcesDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List deploymentResources = this.repositoryService.getDeploymentResources(deploymentOne.getId());
        Assertions.assertThat((List)deploymentResources).hasSize(1);
        deploymentResources = this.repositoryService.getDeploymentResources(deploymentTwo.getId());
        Assertions.assertThat((List)deploymentResources).hasSize(1);
    }

    @Test
    public void failToGetResourceAsStreamNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getResourceAsStream(deployment.getId(), resource.getName())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the deployment");
    }

    @Test
    public void getResourceAsStreamWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resource.getName());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getResourceAsStreamDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        Resource resourceOne = (Resource)this.repositoryService.getDeploymentResources(deploymentOne.getId()).get(0);
        Resource resourceTwo = (Resource)this.repositoryService.getDeploymentResources(deploymentTwo.getId()).get(0);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getResourceAsStream(deploymentOne.getId(), resourceOne.getName());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        inputStream = this.repositoryService.getResourceAsStream(deploymentTwo.getId(), resourceTwo.getName());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void failToGetResourceAsStreamByIdNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getResourceAsStreamById(deployment.getId(), resource.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the deployment");
    }

    @Test
    public void getResourceAsStreamByIdWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getResourceAsStreamById(deployment.getId(), resource.getId());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getResourceAsStreamByIdDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        Resource resourceOne = (Resource)this.repositoryService.getDeploymentResources(deploymentOne.getId()).get(0);
        Resource resourceTwo = (Resource)this.repositoryService.getDeploymentResources(deploymentTwo.getId()).get(0);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getResourceAsStreamById(deploymentOne.getId(), resourceOne.getId());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        inputStream = this.repositoryService.getResourceAsStreamById(deploymentTwo.getId(), resourceTwo.getId());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void redeployForDifferentAuthenticatedTenants() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_TWO).deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the deployment");
    }

    @Test
    public void redeployForTheSameAuthenticatedTenant() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_ONE).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
    }

    @Test
    public void redeployForDifferentAuthenticatedTenantsDisabledTenantCheck() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_TWO).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

