/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyFormVariablesCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String VARIABLE_1 = "testVariable1";
    protected static final String VARIABLE_2 = "testVariable2";
    protected static final String VARIABLE_VALUE_1 = "test1";
    protected static final String VARIABLE_VALUE_2 = "test2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessInstance instance;
    protected static final String START_FORM_RESOURCE = "org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFields.bpmn20.xml";

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, START_FORM_RESOURCE);
        this.instance = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)Variables.createVariables().putValue(VARIABLE_1, (Object)VARIABLE_VALUE_1).putValue(VARIABLE_2, (Object)VARIABLE_VALUE_2));
    }

    @Test
    public void testGetStartFormVariablesWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((long)4L, (long)this.engineRule.getFormService().getStartFormVariables(this.instance.getProcessDefinitionId()).size());
    }

    @Test
    public void testGetStartFormVariablesWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getFormService().getStartFormVariables(this.instance.getProcessDefinitionId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition '" + this.instance.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetStartFormVariablesWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((long)4L, (long)this.engineRule.getFormService().getStartFormVariables(this.instance.getProcessDefinitionId()).size());
    }

    @Test
    public void testGetTaskFormVariablesWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        Assert.assertEquals((long)2L, (long)this.engineRule.getFormService().getTaskFormVariables(task.getId()).size());
    }

    @Test
    public void testGetTaskFormVariablesWithNoAuthenticatedTenant() {
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getFormService().getTaskFormVariables(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the task '" + task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetTaskFormVariablesWithDisabledTenantCheck() {
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((long)2L, (long)this.engineRule.getFormService().getTaskFormVariables(task.getId()).size());
    }
}

