/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchSuspensionHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricOperationLogsForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected BatchSuspensionHelper helper = new BatchSuspensionHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.createUser(this.userId);
        this.identityService.setAuthenticatedUserId(this.userId);
        this.deploySimpleDefinition();
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        ClockUtil.reset();
        this.identityService.clearAuthentication();
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void getHistoricUserOperationLogs_suspendProcessInstanceByProcessInstanceId() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.SUSPENDED.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Activate"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.ACTIVE.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendProcessInstanceByProcessDefinitionId() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.SUSPENDED.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Activate"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.ACTIVE.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendProcessInstanceByProcessDefinitionKey() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("process");
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("process");
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.SUSPENDED.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Activate"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getNewValue(), (Matcher)CoreMatchers.is((Object)SuspensionState.ACTIVE.getName()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendProcessDefinitionById() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.repositoryService.suspendProcessDefinitionById(processInstance.getProcessDefinitionId(), true, null);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.repositoryService.activateProcessDefinitionById(processInstance.getProcessDefinitionId(), true, null);
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)4));
        ArrayList<String> newPossibleValue = new ArrayList<String>(Arrays.asList(SuspensionState.SUSPENDED.getName(), SuspensionState.ACTIVE.getName(), "true", "true"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(0)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processInstance.getProcessDefinitionId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(1)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processInstance.getProcessDefinitionId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(2)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processInstance.getProcessDefinitionId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(3)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processInstance.getProcessDefinitionId()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendProcessDefinitionByKey() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.repositoryService.suspendProcessDefinitionByKey("process", true, null);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.repositoryService.activateProcessDefinitionByKey("process", true, null);
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)4));
        ArrayList<String> newPossibleValue = new ArrayList<String>(Arrays.asList(SuspensionState.SUSPENDED.getName(), SuspensionState.ACTIVE.getName(), "true", "true"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(0)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(1)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(2)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessDefinition"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)newPossibleValue.remove(((UserOperationLogEntry)userOperationsLog.get(3)).getNewValue()));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendByBatchJobAndProcessInstanceId() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        Batch suspendProcess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Collections.singletonList(processInstance.getProcessInstanceId())).suspendAsync();
        this.helper.completeSeedJobs(suspendProcess);
        this.helper.executeJobs(suspendProcess);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        Batch resumeProcess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(Collections.singletonList(processInstance.getProcessInstanceId())).activateAsync();
        this.helper.completeSeedJobs(resumeProcess);
        this.helper.executeJobs(resumeProcess);
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getNewValue(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionKey(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
    }

    @Test
    public void getHistoricUserOperationLogs_suspendByBatchJobAndQuery() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        Batch suspendprocess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().active()).suspendAsync();
        this.helper.completeSeedJobs(suspendprocess);
        this.helper.executeJobs(suspendprocess);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        Batch resumeProcess = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery().suspended()).activateAsync();
        this.helper.completeSeedJobs(resumeProcess);
        this.helper.executeJobs(resumeProcess);
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionKey(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"SuspendJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getNewValue(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionKey(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessDefinitionId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"Operator"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getOperationType(), (Matcher)CoreMatchers.is((Object)"ActivateJob"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(3)).getEntityType(), (Matcher)CoreMatchers.is((Object)"ProcessInstance"));
    }

    @Test
    public void occurredAfterParameterWorks() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(now, null, 10);
        HashSet<String> allowedOperationsTypes = new HashSet<String>(Arrays.asList("Suspend", "Activate"));
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)allowedOperationsTypes.contains(((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType()));
        Assert.assertTrue((boolean)allowedOperationsTypes.contains(((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType()));
    }

    @Test
    public void occurredAtParameterWorks() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(null, now, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
    }

    @Test
    public void occurredAfterAndOccurredAtParameterWorks() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(now, now, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByTimestamp() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.activateProcessInstanceById(processInstance.getProcessInstanceId());
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.runtimeService.suspendProcessInstanceById(processInstance.getProcessInstanceId());
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Activate"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Suspend"));
    }

    @Test
    public void fetchOnlyProcessInstanceSuspensionStateBasedLogEntries() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.createLogEntriesThatShouldNotBeReturned(processInstance.getId());
        MatcherAssert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void createLogEntriesThatShouldNotBeReturned(String processInstanceId) {
        ClockUtil.setCurrentTime((Date)new Date());
        String processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(processTaskId, "er");
        this.taskService.deleteCandidateUser(processTaskId, "er");
        this.taskService.addCandidateGroup(processTaskId, "wir");
        this.taskService.deleteCandidateGroup(processTaskId, "wir");
        this.taskService.setOwner(processTaskId, "icke");
        this.taskService.setPriority(processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", processTaskId, processInstanceId, "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.runtimeService.deleteProcessInstance(processInstanceId, "that's why");
        Task userTask = this.taskService.newTask();
        userTask.setName("to do");
        this.taskService.saveTask(userTask);
        ClockUtil.setCurrentTime((Date)new Date());
        userTask.setDescription("desc");
        userTask.setOwner("icke");
        userTask.setAssignee("er");
        userTask.setDueDate(new Date());
        this.taskService.saveTask(userTask);
        this.taskService.deleteTask(userTask.getId(), true);
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void deploySimpleDefinition() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
    }
}

