/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.ObjectValueBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricVariableUpdatesForOptimizeTest {
    private static final String USER_ID = "test";
    private static final TypedValue STRING_VARIABLE_DEFAULT_VALUE = Variables.stringValue((String)"aString");
    private static final ObjectValueBuilder OBJECT_VARIABLE_DEFAULT_VALUE = Variables.objectValue((Object)ImmutableList.of((Object)"one", (Object)"two", (Object)"three"));
    private static final TypedValue BYTE_VARIABLE_DEFAULT_VALUE = Variables.byteArrayValue((byte[])new byte[]{8, 6, 3, 4, 2, 6, 7, 8});
    private static final FileValue FILE_VARIABLE_DEFAULT_VALUE = (FileValue)Variables.fileValue((String)"test.txt").file("some bytes".getBytes()).mimeType("text/plain").create();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(USER_ID);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getHistoricVariableUpdates() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "foo");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, false, 10);
        Assertions.assertThat((int)historicVariableUpdates.size()).isEqualTo(1);
        this.assertThatUpdateHasAllImportantInformation((HistoricVariableUpdate)historicVariableUpdates.get(0));
    }

    @Test
    public void occurredAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(new Date().getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, null, false, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getValue().toString()).isEqualTo((Object)"value2");
    }

    @Test
    public void occurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(null, now, false, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getValue().toString()).isEqualTo((Object)"value1");
    }

    @Test
    public void occurredAfterAndOccurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.put("stringVar", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, now, false, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(0);
    }

    @Test
    public void mixedTypeVariablesByDefaultAllNonBinaryValuesAreFetched() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Map<String, Object> mixedTypeVariableMap = this.createMixedTypeVariableMap();
        this.runtimeService.startProcessInstanceByKey("process", mixedTypeVariableMap);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, false, 10);
        Assertions.assertThat((List)historicVariableUpdates).extracting(HistoricVariableUpdate::getVariableName).containsExactlyInAnyOrderElementsOf(mixedTypeVariableMap.keySet());
        Assertions.assertThat((List)historicVariableUpdates).extracting(this::extractVariableValue).containsExactlyInAnyOrder(new Object[]{STRING_VARIABLE_DEFAULT_VALUE.getValue(), ((ObjectValue)OBJECT_VARIABLE_DEFAULT_VALUE.create()).getValueSerialized(), null, null});
    }

    @Test
    public void mixedTypeVariablesExcludeObjectValueDiscardsObjectValue() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Map<String, Object> mixedTypeVariableMap = this.createMixedTypeVariableMap();
        this.runtimeService.startProcessInstanceByKey("process", mixedTypeVariableMap);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, true, 10);
        Assertions.assertThat((List)historicVariableUpdates).extracting(HistoricVariableUpdate::getVariableName).containsExactlyInAnyOrderElementsOf(mixedTypeVariableMap.keySet());
        Assertions.assertThat((List)historicVariableUpdates).extracting(this::extractVariableValue).containsExactlyInAnyOrder(new Object[]{STRING_VARIABLE_DEFAULT_VALUE.getValue(), null, null, null});
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "value1");
        variables.put("integerVar", 1);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(this.pastDate(), null, false, 3);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(3);
    }

    @Test
    public void resultIsSortedByTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus1Second = new Date(now.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)nowPlus1Second);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        variables.clear();
        variables.put("var2", "value2");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        Date nowPlus4Seconds = new Date(nowPlus2Seconds.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        variables.clear();
        variables.put("var3", "value3");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(now, null, false, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(3);
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(0)).getVariableName()).isEqualTo((Object)"var1");
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(1)).getVariableName()).isEqualTo((Object)"var2");
        Assertions.assertThat((String)((HistoricVariableUpdate)variableUpdates.get(2)).getVariableName()).isEqualTo((Object)"var3");
    }

    @Test
    public void fetchOnlyVariableUpdates() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> formFields = new HashMap<String, String>();
        formFields.put("var", "foo");
        this.engineRule.getFormService().submitTaskForm(task.getId(), formFields);
        long detailCount = this.engineRule.getHistoryService().createHistoricDetailQuery().count();
        Assertions.assertThat((long)detailCount).isEqualTo(2L);
        List variableUpdates = this.optimizeService.getHistoricVariableUpdates(this.pastDate(), null, false, 10);
        Assertions.assertThat((int)variableUpdates.size()).isEqualTo(1);
    }

    @Test
    @RequiredDatabase(excludes={"h2", "cockroachdb"})
    public void testFetchLargeNumberOfObjectVariables() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("waitState").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        int numberOfVariables = 3000;
        VariableMap variables = this.createVariables(numberOfVariables);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(1L), null, false, 10000);
        Assertions.assertThat((List)historicVariableUpdates).hasSize(numberOfVariables);
        for (HistoricVariableUpdate update : historicVariableUpdates) {
            ObjectValue typedValue = (ObjectValue)update.getTypedValue();
            Assertions.assertThat((String)typedValue.getValueSerialized()).isNotNull();
        }
    }

    private Object extractVariableValue(HistoricVariableUpdate variableUpdate) {
        TypedValue typedValue = variableUpdate.getTypedValue();
        if (typedValue instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)typedValue;
            return objectValue.isDeserialized() ? objectValue.getValue() : objectValue.getValueSerialized();
        }
        return typedValue.getValue();
    }

    private Map<String, Object> createMixedTypeVariableMap() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", STRING_VARIABLE_DEFAULT_VALUE);
        variables.put("objVar", OBJECT_VARIABLE_DEFAULT_VALUE);
        variables.put("byteVar", BYTE_VARIABLE_DEFAULT_VALUE);
        variables.put("fileVar", FILE_VARIABLE_DEFAULT_VALUE);
        return variables;
    }

    private VariableMap createVariables(int num) {
        VariableMap variables = Variables.createVariables();
        for (int i = 0; i < num; ++i) {
            variables.put((Object)("var" + i), (Object)Variables.objectValue((Object)i));
        }
        return variables;
    }

    private Date pastDate() {
        return new Date(2L);
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatUpdateHasAllImportantInformation(HistoricVariableUpdate variableUpdate) {
        Assertions.assertThat((Object)variableUpdate).isNotNull();
        Assertions.assertThat((String)variableUpdate.getId()).isNotNull();
        Assertions.assertThat((String)variableUpdate.getProcessDefinitionKey()).isEqualTo((Object)"process");
        Assertions.assertThat((String)variableUpdate.getProcessDefinitionId()).isNotNull();
        Assertions.assertThat((String)variableUpdate.getVariableName()).isEqualTo((Object)"stringVar");
        Assertions.assertThat((Object)variableUpdate.getValue()).hasToString("foo");
        Assertions.assertThat((String)variableUpdate.getTypeName()).isEqualTo((Object)"string");
        Assertions.assertThat((Date)variableUpdate.getTime()).isNotNull();
    }
}

