/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Collection;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.junit.Assert;
import org.junit.Test;

public class BpmnModelInstanceCmdTest
extends PluggableProcessEngineTest {
    private static final String PROCESS_KEY = "one";

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.bpmn20.xml"})
    @Test
    public void testRepositoryService() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_KEY).singleResult()).getId();
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        Assert.assertNotNull((Object)modelInstance);
        Collection events = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Event.class));
        Assert.assertEquals((long)2L, (long)events.size());
        Collection sequenceFlows = modelInstance.getModelElementsByType(modelInstance.getModel().getType(SequenceFlow.class));
        Assert.assertEquals((long)1L, (long)sequenceFlows.size());
        StartEvent startEvent = (StartEvent)modelInstance.getModelElementById("start");
        Assert.assertNotNull((Object)startEvent);
    }
}

