/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class VersionTagTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testParsingVersionTag() {
        ProcessDefinition process = (ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().asc()).singleResult();
        Assert.assertEquals((Object)"ver_tag_1", (Object)process.getVersionTag());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml"})
    @Test
    public void testParsingNullVersionTag() {
        ProcessDefinition process = (ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().asc()).singleResult();
        Assert.assertEquals(null, (Object)process.getVersionTag());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/versionTag.dmn"})
    @Test
    public void testParsingVersionTagDecisionDefinition() {
        DecisionDefinition decision = (DecisionDefinition)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).singleResult();
        Assert.assertEquals((Object)"1.0.0", (Object)decision.getVersionTag());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/noVersionTag.dmn"})
    @Test
    public void testParsingNullVersionTagDecisionDefinition() {
        DecisionDefinition decision = (DecisionDefinition)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).singleResult();
        Assert.assertEquals(null, (Object)decision.getVersionTag());
    }
}

