/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class ProcessInstanceModificationHistoryTest
extends PluggableProcessEngineTest {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_ASYNC_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        Assert.assertNotNull((Object)procInstVariable);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"procInstVar", (Object)procInstVariable.getName());
        Assert.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        Assert.assertNotNull((Object)procInstanceVarDetail);
        Assert.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertNull((Object)localVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"localVar", (Object)localVariable.getName());
        Assert.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        Assert.assertNotNull((Object)localInstanceVarDetail);
        Assert.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    @Test
    public void testStartBeforeAsyncWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        Assert.assertNotNull((Object)procInstVariable);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"procInstVar", (Object)procInstVariable.getName());
        Assert.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        Assert.assertNotNull((Object)procInstanceVarDetail);
        Assert.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertNull((Object)localVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"localVar", (Object)localVariable.getName());
        Assert.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        Assert.assertNotNull((Object)localInstanceVarDetail);
        Assert.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    @Test
    public void testStartBeforeScopeWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        Assert.assertNotNull((Object)procInstVariable);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"procInstVar", (Object)procInstVariable.getName());
        Assert.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        Assert.assertNotNull((Object)procInstanceVarDetail);
        Assert.assertNull((Object)procInstanceVarDetail.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)updatedTree.getActivityInstances("subProcess")[0].getId(), (Object)localVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"localVar", (Object)localVariable.getName());
        Assert.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        Assert.assertNotNull((Object)localInstanceVarDetail);
        Assert.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionWithVariablesInHistory() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricVariableInstance procInstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("procInstVar").singleResult();
        Assert.assertNotNull((Object)procInstVariable);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"procInstVar", (Object)procInstVariable.getName());
        Assert.assertEquals((Object)"procInstValue", (Object)procInstVariable.getValue());
        HistoricDetail procInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(procInstVariable.getId()).singleResult();
        Assert.assertNotNull((Object)procInstanceVarDetail);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        HistoricVariableInstance localVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("localVar").singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)updatedTree.getId(), (Object)procInstVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"localVar", (Object)localVariable.getName());
        Assert.assertEquals((Object)"localValue", (Object)localVariable.getValue());
        HistoricDetail localInstanceVarDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(localVariable.getId()).singleResult();
        Assert.assertNotNull((Object)localInstanceVarDetail);
        Assert.assertNull((Object)localInstanceVarDetail.getActivityInstanceId());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelTaskShouldCancelProcessInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("theTask").execute(true, false);
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
        Assert.assertNotNull((Object)instance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSkipCustomListenerEnsureHistoryWritten() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("exclusiveGateway").getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task2")).execute(true, false);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        HistoricActivityInstance instance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)task.getId(), (Object)instance.getTaskId());
        Assert.assertEquals((Object)"kermit", (Object)instance.getAssignee());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricVariablesOnAsyncBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.executeJob((Job)this.managementService.createJobQuery().singleResult());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theStart")).execute(true, true);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    @Test
    public void testModifyWithNonInitialVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.executeJob((Job)this.managementService.createJobQuery().singleResult());
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theStart")).setVariable("var1", (Object)"value1")).execute(true, true);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstance.getId(), (Object)variable.getProcessInstanceId());
        HistoricVariableUpdateEventEntity historicDetail = (HistoricVariableUpdateEventEntity)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)historicDetail);
        Assert.assertFalse((boolean)historicDetail.isInitial());
        Assert.assertEquals((Object)"var1", (Object)historicDetail.getVariableName());
        Assert.assertEquals((Object)"value1", (Object)historicDetail.getTextValue());
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }

    protected void executeJob(Job job) {
        while (job != null && job.getRetries() > 0) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }
}

