/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationSignallableServiceTaskTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCannotMigrateActivityInstance() {
        BpmnModelInstance model = ((ServiceTaskBuilder)ProcessModels.newModel().startEvent().serviceTask("serviceTask").camundaClass(SignallableServiceTaskDelegate.class.getName())).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("serviceTask", "serviceTask").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasActivityInstanceFailures("serviceTask", "The type of the source activity is not supported for activity instance migration");
        }
    }

    @Test
    public void testCannotMigrateAsyncActivityInstance() {
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)ProcessModels.newModel().startEvent().serviceTask("serviceTask").camundaAsyncBefore()).camundaClass(SignallableServiceTaskDelegate.class.getName())).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("serviceTask", "serviceTask").build();
        String processInstanceId = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId()).getId();
        this.testHelper.executeAvailableJobs();
        try {
            this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstanceId}).execute();
            Assert.fail((String)"should fail");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasActivityInstanceFailures("serviceTask", "The type of the source activity is not supported for activity instance migration");
        }
    }

    public static class SignallableServiceTaskDelegate
    implements SignallableActivityBehavior {
        public void execute(ActivityExecution execution) throws Exception {
        }

        public void signal(ActivityExecution execution, String signalEvent, Object signalData) throws Exception {
            PvmTransition transition = (PvmTransition)execution.getActivity().getOutgoingTransitions().get(0);
            execution.leaveActivityViaTransition(transition);
        }
    }
}

