/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchSetVariablesMigrationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule).around((TestRule)this.testRule);

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void clearAuthentication() {
        this.engineRule.getIdentityService().clearAuthentication();
    }

    @After
    public void resetEngineConfig() {
        this.engineRule.getProcessEngineConfiguration().setRestrictUserOperationLogToAuthenticatedUsers(true);
    }

    @Test
    public void shouldCreateBatchVariable() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"));
        this.helper.completeSeedJobs(batch);
        VariableInstance batchVariable = (VariableInstance)this.engineRule.getRuntimeService().createVariableInstanceQuery().batchIdIn(new String[]{batch.getId()}).singleResult();
        Assertions.assertThat((Object)batchVariable).extracting(new String[]{"name", "value"}).containsExactly(new Object[]{"foo", "bar"});
    }

    @Test
    public void shouldCreateBatchVariables() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo"));
        List batchVariables = this.engineRule.getRuntimeService().createVariableInstanceQuery().batchIdIn(new String[]{batch.getId()}).list();
        Assertions.assertThat((List)batchVariables).extracting(new String[]{"name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "bar"}), Assertions.tuple((Object[])new Object[]{"bar", "foo"})});
    }

    @Test
    public void shouldRemoveBatchVariable() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"));
        this.helper.completeBatch(batch);
        List batchVariables = this.engineRule.getRuntimeService().createVariableInstanceQuery().batchIdIn(new String[]{batch.getId()}).list();
        Assertions.assertThat((List)batchVariables).isEmpty();
    }

    @Test
    public void shouldSetVariables() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"));
        this.helper.completeBatch(batch);
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().list();
        Assertions.assertThat((List)variables).extracting(new String[]{"processDefinitionId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{targetProcessDefinition.getId(), "foo", "bar"}), Assertions.tuple((Object[])new Object[]{targetProcessDefinition.getId(), "foo", "bar"}), Assertions.tuple((Object[])new Object[]{targetProcessDefinition.getId(), "foo", "bar"}), Assertions.tuple((Object[])new Object[]{targetProcessDefinition.getId(), "foo", "bar"}), Assertions.tuple((Object[])new Object[]{targetProcessDefinition.getId(), "foo", "bar"})});
    }

    @Test
    public void shouldThrowException_TransientVariable() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId()).getId();
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().setVariables((Map)Variables.putValue((String)"foo", (Object)Variables.stringValue((String)"bar", (boolean)true))).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstanceId}).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("ENGINE-13044 Setting transient variable 'foo' asynchronously is currently not supported.");
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldLogOperationOnCreation() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"), true);
        List operationLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        Assertions.assertThat((List)operationLogEntries).extracting(new String[]{"operationType", "userId", "property", "newValue"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Migrate", "user", "processDefinitionId", targetProcessDefinition.getId()}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfInstances", "5"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "nrOfSetVariables", "1"}), Tuple.tuple((Object[])new Object[]{"Migrate", "user", "async", "true"})});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotLogOperationOnExecution() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"));
        this.engineRule.getIdentityService().setAuthenticatedUserId("user");
        this.helper.completeBatch(batch);
        List operationLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        ((AbstractListAssert)Assertions.assertThat((List)operationLogEntries).extracting("operationType").hasSize(7)).containsOnly(new Object[]{"Execute"});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotLogOperationOnExecutionUnauthenticated() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = this.helper.migrateProcessInstancesAsync(5, sourceProcessDefinition, targetProcessDefinition, (Map<String, Object>)Variables.putValue((String)"foo", (Object)"bar"));
        this.engineRule.getProcessEngineConfiguration().setRestrictUserOperationLogToAuthenticatedUsers(false);
        this.helper.completeBatch(batch);
        List operationLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        ((AbstractListAssert)Assertions.assertThat((List)operationLogEntries).extracting("operationType").hasSize(7)).containsOnly(new Object[]{"Execute"});
    }
}

