/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
public class TaskLastUpdatedTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    TaskService taskService;
    RuntimeService runtimeService;

    @Before
    public void setUp() {
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @After
    public void tearDown() {
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            if (task.getProcessDefinitionId() != null) continue;
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    public Date getAfterCurrentTime() {
        return new Date(ClockUtil.getCurrentTime().getTime() + 1000L);
    }

    public Date getBeforeCurrentTime() {
        return new Date(ClockUtil.getCurrentTime().getTime() - 1000L);
    }

    @Test
    public void shouldNotSetLastUpdatedWithoutTaskUpdate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNull();
    }

    @Test
    @RequiredDatabase(excludes={"mysql"})
    public void shouldSetLastUpdatedToExactlyNow() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        Date now = new Date(beforeUpdate.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.setAssignee(task.getId(), "myself");
        Assertions.assertThat((Date)task.getLastUpdated()).isNull();
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(beforeUpdate).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isEqualTo((Object)now);
    }

    @Test
    @RequiredDatabase(includes={"mysql"})
    public void shouldSetLastUpdatedToExactlyNowIgnoringMillis() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        Date now = new Date(beforeUpdate.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.setAssignee(task.getId(), "myself");
        Assertions.assertThat((Date)task.getLastUpdated()).isNull();
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(beforeUpdate).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isEqualToIgnoringMillis(now);
    }

    @Test
    public void shouldSetLastUpdatedOnDescriptionChange() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDescription("updated");
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnAssigneeChange() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setAssignee("myself");
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnVariableChange() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.setVariableLocal(task.getId(), "myVariable", (Object)"variableValue");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnCreateAttachment() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.createAttachment(null, task.getId(), processInstance.getId(), "myAttachment", "attachmentDescription", "http://camunda.com");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnChangeAttachment() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Attachment attachment = this.taskService.createAttachment(null, task.getId(), processInstance.getId(), "myAttachment", "attachmentDescription", "http://camunda.com");
        attachment.setDescription("updatedDescription");
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.saveAttachment(attachment);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnDeleteAttachment() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Attachment attachment = this.taskService.createAttachment(null, task.getId(), processInstance.getId(), "myAttachment", "attachmentDescription", "http://camunda.com");
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.deleteAttachment(attachment.getId());
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnComment() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.createComment(task.getId(), processInstance.getId(), "my comment");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnClaimTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.claim(task.getId(), "myself");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnEveryPropertyChange() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setAssignee("myself");
        this.taskService.saveTask(task);
        Date expectedBeforeSecondUpdate = this.getBeforeCurrentTime();
        task.setName("My Task");
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(expectedBeforeSecondUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnDelegate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.claim(task.getId(), "myself");
        Date beforeDelegate = this.getBeforeCurrentTime();
        this.taskService.delegateTask(task.getId(), "someone");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeDelegate);
    }

    @Test
    public void shouldSetLastUpdatedOnResolve() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.resolveTask(task.getId());
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnAddIdentityLink() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.addCandidateUser(task.getId(), "myself");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnDeleteIdentityLink() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.addCandidateUser(task.getId(), "myself");
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.deleteUserIdentityLink(task.getId(), "myself", "candidate");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    public void shouldSetLastUpdatedOnPriorityChange() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date beforeUpdate = this.getBeforeCurrentTime();
        this.taskService.setPriority(task.getId(), 1);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeUpdate);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedCamundaFormSingleTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/task.html"})
    public void shouldSetLastUpdatedOnSubmitTaskForm() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormsProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.delegateTask(task.getId(), "myself");
        Date beforeSubmit = this.getBeforeCurrentTime();
        this.engineRule.getFormService().submitTaskForm(task.getId(), null);
        Task taskResult = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeSubmit);
    }

    @Test
    public void shouldNotSaveTaskConcurrentlyUpdatedByDependentEntity() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.createComment(task.getId(), null, "");
        Assertions.assertThatThrownBy(() -> this.taskService.saveTask(task)).isInstanceOf(OptimisticLockingException.class);
    }
}

