/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.junit.Assert;
import org.junit.Test;

public class BoundaryConditionalEventTest
extends AbstractConditionalEventTestCase {
    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testNonInterruptingTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task task = (Task)taskQuery.processInstanceId(procInst.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Task with condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment
    public void testVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Task with condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testVariableSetOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).activityId("taskWithCondition").singleResult();
        Assert.assertNull((Object)execution);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment
    public void testNonInterruptingVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testWrongVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment
    public void testParallelVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((long)2L, (long)this.conditionEventSubscriptionQuery.list().size());
        Task task = (Task)tasks.get(0);
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testParallelVariableCondition.bpmn20.xml"})
    public void testParallelSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task task = (Task)tasks.get(0);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((long)0L, (long)executions.size());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testParallelVariableCondition.bpmn20.xml"})
    public void testParallelSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((long)0L, (long)executions.size());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task in Subprocess", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task in Subprocess", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/BoundaryConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task in Subprocess", (Object)task.getName());
        this.runtimeService.setVariable(task.getExecutionId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testNonInterruptingSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task in Subprocess", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testCleanUpConditionalEventSubscriptions() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    protected void deployBoundaryEventProcess(AbstractActivityBuilder builder, boolean isInterrupting) {
        this.deployBoundaryEventProcess(builder, "${variable == 1}", isInterrupting);
    }

    protected void deployBoundaryEventProcess(AbstractActivityBuilder builder, String conditionExpr, boolean isInterrupting) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)builder.boundaryEvent().cancelActivity(Boolean.valueOf(isInterrupting))).conditionalEventDefinition("conditionalEvent").condition(conditionExpr)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    @Test
    public void testSetVariableInDelegate() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingSetVariableInDelegate() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaClass(SetVariableDelegate.class.getName())).userTask().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testSetVariableInDelegateWithSynchronousEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(modelInstance).serviceTaskBuilder("taskWithCondition").boundaryEvent().cancelActivity(Boolean.valueOf(true))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testNonInterruptingSetVariableInDelegateWithSynchronousEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaClass(SetVariableDelegate.class.getName())).userTask().endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(modelInstance).serviceTaskBuilder("taskWithCondition").boundaryEvent().cancelActivity(Boolean.valueOf(false))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInInputMapping() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaInputParameter("variable", "1")).camundaExpression("${true}")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInInputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaInputParameter("variable", "1")).camundaExpression("${true}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInExpression() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaExpression("${execution.setVariable(\"variable\", 1)}")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInExpression() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testSetVariableInInputMappingOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent().userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingSetVariableInInputMappingOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent().userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"taskInSubProcess", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInStartListenerOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).embeddedSubProcess().startEvent().userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingSetVariableInStartListenerOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).embeddedSubProcess().startEvent().userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaOutputParameter("variable", "1")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "beforeConditionId", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInOutputMappingWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaOutputParameter("variable", "1")).userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaOutputParameter("variable", "1")).userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testNonInterruptingSetVariableInOutputMappingWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).camundaOutputParameter("variable", "1")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInOutputMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOutputParameter("variable", "1")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutputMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOutputParameter("variable", "1")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.count());
    }

    @Test
    public void testSetVariableInInMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaIn("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInInMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaIn("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInStartListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Task with condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInTakeListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).sequenceFlowId("flow")).userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaExpression("${execution.setVariable(\"variable\", 1)}");
        ((SequenceFlow)modelInstance.getModelElementById("flow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).userTask().name("After Task")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Task", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInEndListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).userTask().name("After Task")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Task", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInMultiInstance() {
        BpmnModelInstance modelInstance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").multiInstance().cardinality("3")).parallel()).done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", "${nrOfInstances == 3}", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInMultiInstance() {
        BpmnModelInstance modelInstance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").multiInstance().cardinality("3")).parallel()).done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", "${nrOfInstances == 3}", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        List multiInstanceTasks = taskQuery.taskDefinitionKey("taskWithCondition").list();
        Assert.assertEquals((long)3L, (long)multiInstanceTasks.size());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().taskName("After Condition").count());
        for (Task multiInstanceTask : multiInstanceTasks) {
            this.taskService.complete(multiInstanceTask.getId());
        }
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)9L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInSeqMultiInstance() {
        BpmnModelInstance modelInstance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").multiInstance().cardinality("3")).sequential()).done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", "${true}", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInSeqMultiInstance() {
        BpmnModelInstance modelInstance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").multiInstance().cardinality("3")).sequential()).done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", "${true}", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        for (int i = 0; i < 3; ++i) {
            Task multiInstanceTask = (Task)taskQuery.taskDefinitionKey("taskWithCondition").singleResult();
            Assert.assertNotNull((Object)multiInstanceTask);
            Assert.assertEquals((long)(i == 0 ? 5L : (long)(5 + i * 2)), (long)this.taskService.createTaskQuery().taskName("After Condition").count());
            this.taskService.complete(multiInstanceTask.getId());
        }
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)9L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInSubProcessInDelegatedCode() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInSubProcessInDelegatedCode() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetMultipleVariables() {
        BpmnModelInstance modelInstance = ((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(true))).conditionalEventDefinition("event1").condition("${variable1 == 1}")).conditionalEventDefinitionDone().userTask("afterBoundary1").endEvent().moveToActivity("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(true))).conditionalEventDefinition("event2").condition("${variable2 == 1}")).conditionalEventDefinitionDone().userTask("afterBoundary2").endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)Variables.createVariables().putValue("variable1", (Object)"44").putValue("variable2", (Object)"44"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), (Map)Variables.createVariables().putValue("variable1", (Object)1).putValue("variable2", (Object)1));
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        String taskDefinitionKey = ((Task)this.tasksAfterVariableIsSet.get(0)).getTaskDefinitionKey();
        Assert.assertTrue(("afterBoundary1".equals(taskDefinitionKey) || "afterBoundary2".equals(taskDefinitionKey) ? 1 : 0) != 0);
    }

    @Test
    @Deployment
    public void testTrueConditionWithExecutionListener() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSuspendedProcess() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.runtimeService.suspendProcessInstanceById(procInst.getId());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Assert.assertTrue((boolean)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).isSuspended());
        try {
            this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
            Assert.fail((String)"Should fail!");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(procInst.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
    }

    @Test
    public void testNonInterruptingConditionalSuspendedProcess() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").endEvent().done();
        this.deployConditionalBoundaryEventProcess(modelInstance, "taskWithCondition", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.runtimeService.suspendProcessInstanceById(procInst.getId());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Assert.assertTrue((boolean)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).isSuspended());
        try {
            this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
            Assert.fail((String)"Should fail!");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(procInst.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
    }
}

