/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.end;

import java.util.HashMap;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SignalEndEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testCatchSignalEndEventInEmbeddedSubprocess() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("catchSignalEndEventInEmbeddedSubprocess");
        Assert.assertNotNull((Object)processInstance);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task after catching the signal", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/SignalEndEventTest.catchSignalEndEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/end/SignalEndEventTest.processWithSignalEndEvent.bpmn20.xml"})
    @Test
    public void testCatchSignalEndEventInCallActivity() throws Exception {
        ProcessInstance processInstanceCatchEvent = this.runtimeService.startProcessInstanceByKey("catchSignalEndEvent");
        Assert.assertNotNull((Object)processInstanceCatchEvent);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)"alert", (Object)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName());
        ProcessInstance processInstanceEndEvent = this.runtimeService.startProcessInstanceByKey("processWithSignalEndEvent");
        Assert.assertNotNull((Object)processInstanceEndEvent);
        this.testRule.assertProcessEnded(processInstanceEndEvent.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterSignalCatch", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceCatchEvent.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/testPropagateOutputVariablesWhileThrowSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEndEventTest.parent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowSignal() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("SignalParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/testPropagateOutputVariablesWhileThrowSignal2.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEndEventTest.parent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowSignal2() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("SignalParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("inside subprocess").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    protected void checkOutput(String processInstanceId) {
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched signal").count());
        Assert.assertNotNull((Object)this.runtimeService.getVariable(processInstanceId, "cancelReason"));
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "input"));
    }
}

