/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.test.bpmn.event.error.MyBusinessException;

public class ThrowErrorDelegate
extends AbstractBpmnActivityBehavior
implements Serializable {
    public static final long serialVersionUID = 1L;

    public void execute(ActivityExecution execution) throws Exception {
        this.handle(execution, "executed");
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.handle(execution, "signaled");
    }

    protected void handle(ActivityExecution execution, String action) throws Exception {
        execution.setVariable(action, (Object)true);
        String type = (String)execution.getVariable("type");
        if ("error".equalsIgnoreCase(type)) {
            throw new BpmnError("MyError");
        }
        if ("exception".equalsIgnoreCase(type)) {
            throw new MyBusinessException("MyException");
        }
        if ("leave".equalsIgnoreCase(type)) {
            execution.setVariable("type", null);
            this.leave(execution);
        }
    }

    public static Map<String, Object> throwError() {
        return Collections.singletonMap("type", "error");
    }

    public static Map<String, Object> throwException() {
        return Collections.singletonMap("type", "exception");
    }

    public static Map<String, Object> leaveExecution() {
        return Collections.singletonMap("type", "leave");
    }
}

