/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import java.util.Collection;
import org.camunda.bpm.engine.test.bpmn.executionlistener.ModelExecutionContextExecutionListener;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.CatchEvent;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.Gateway;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.ParallelGateway;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionListenerBpmnModelExecutionContextTest
extends PluggableProcessEngineTest {
    private static final String PROCESS_ID = "process";
    private static final String START_ID = "start";
    private static final String SEQUENCE_FLOW_ID = "sequenceFlow";
    private static final String CATCH_EVENT_ID = "catchEvent";
    private static final String GATEWAY_ID = "gateway";
    private static final String USER_TASK_ID = "userTask";
    private static final String END_ID = "end";
    private static final String MESSAGE_ID = "messageId";
    private static final String MESSAGE_NAME = "messageName";
    private String deploymentId;

    @Test
    public void testProcessStartEvent() {
        this.deployAndStartTestProcess(PROCESS_ID, START_ID);
        this.assertFlowElementIs(StartEvent.class);
        this.sendMessage();
        this.completeTask();
    }

    @Test
    public void testStartEventEndEvent() {
        this.deployAndStartTestProcess(START_ID, END_ID);
        this.assertFlowElementIs(StartEvent.class);
        this.sendMessage();
        this.completeTask();
    }

    @Test
    public void testSequenceFlowTakeEvent() {
        this.deployAndStartTestProcess(SEQUENCE_FLOW_ID, "take");
        this.assertFlowElementIs(SequenceFlow.class);
        this.sendMessage();
        this.completeTask();
    }

    @Test
    public void testIntermediateCatchEventStartEvent() {
        this.deployAndStartTestProcess(CATCH_EVENT_ID, START_ID);
        this.assertFlowElementIs(IntermediateCatchEvent.class);
        this.sendMessage();
        this.completeTask();
    }

    @Test
    public void testIntermediateCatchEventEndEvent() {
        this.deployAndStartTestProcess(CATCH_EVENT_ID, END_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.assertFlowElementIs(IntermediateCatchEvent.class);
        this.completeTask();
    }

    @Test
    public void testGatewayStartEvent() {
        this.deployAndStartTestProcess(GATEWAY_ID, START_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.assertFlowElementIs(Gateway.class);
        this.completeTask();
    }

    @Test
    public void testGatewayEndEvent() {
        this.deployAndStartTestProcess(GATEWAY_ID, END_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.assertFlowElementIs(ParallelGateway.class);
        this.completeTask();
    }

    @Test
    public void testUserTaskStartEvent() {
        this.deployAndStartTestProcess(USER_TASK_ID, START_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.assertFlowElementIs(UserTask.class);
        this.completeTask();
    }

    @Test
    public void testUserTaskEndEvent() {
        this.deployAndStartTestProcess(USER_TASK_ID, END_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.completeTask();
        this.assertFlowElementIs(UserTask.class);
    }

    @Test
    public void testEndEventStartEvent() {
        this.deployAndStartTestProcess(END_ID, START_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.completeTask();
        this.assertFlowElementIs(EndEvent.class);
    }

    @Test
    public void testProcessEndEvent() {
        this.deployAndStartTestProcess(PROCESS_ID, END_ID);
        this.assertNotNotified();
        this.sendMessage();
        this.completeTask();
        this.assertFlowElementIs(EndEvent.class);
    }

    private void assertNotNotified() {
        Assert.assertNull((Object)ModelExecutionContextExecutionListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextExecutionListener.flowElement);
    }

    private void assertFlowElementIs(Class<? extends FlowElement> elementClass) {
        BpmnModelInstance modelInstance = ModelExecutionContextExecutionListener.modelInstance;
        Assert.assertNotNull((Object)modelInstance);
        Model model = modelInstance.getModel();
        Collection events = modelInstance.getModelElementsByType(model.getType(Event.class));
        Assert.assertEquals((long)3L, (long)events.size());
        Collection gateways = modelInstance.getModelElementsByType(model.getType(Gateway.class));
        Assert.assertEquals((long)1L, (long)gateways.size());
        Collection tasks = modelInstance.getModelElementsByType(model.getType(Task.class));
        Assert.assertEquals((long)1L, (long)tasks.size());
        FlowElement flowElement = ModelExecutionContextExecutionListener.flowElement;
        Assert.assertNotNull((Object)flowElement);
        Assert.assertTrue((boolean)elementClass.isAssignableFrom(flowElement.getClass()));
    }

    private void sendMessage() {
        this.runtimeService.correlateMessage(MESSAGE_NAME);
    }

    private void completeTask() {
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    private void deployAndStartTestProcess(String elementId, String eventName) {
        BpmnModelInstance modelInstance = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent(START_ID).sequenceFlowId(SEQUENCE_FLOW_ID)).intermediateCatchEvent(CATCH_EVENT_ID).parallelGateway(GATEWAY_ID).userTask(USER_TASK_ID).endEvent(END_ID).done();
        this.addMessageEventDefinition((CatchEvent)modelInstance.getModelElementById(CATCH_EVENT_ID));
        this.addExecutionListener((BaseElement)modelInstance.getModelElementById(elementId), eventName);
        this.deployAndStartProcess(modelInstance);
    }

    private void addMessageEventDefinition(CatchEvent catchEvent) {
        BpmnModelInstance modelInstance = (BpmnModelInstance)catchEvent.getModelInstance();
        Message message = (Message)modelInstance.newInstance(Message.class);
        message.setId(MESSAGE_ID);
        message.setName(MESSAGE_NAME);
        modelInstance.getDefinitions().addChildElement((ModelElementInstance)message);
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)modelInstance.newInstance(MessageEventDefinition.class);
        messageEventDefinition.setMessage(message);
        catchEvent.getEventDefinitions().add(messageEventDefinition);
    }

    private void addExecutionListener(BaseElement element, String eventName) {
        ExtensionElements extensionElements = (ExtensionElements)element.getModelInstance().newInstance(ExtensionElements.class);
        ModelElementInstance executionListener = extensionElements.addExtensionElement("http://camunda.org/schema/1.0/bpmn", "executionListener");
        executionListener.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class", ModelExecutionContextExecutionListener.class.getName());
        executionListener.setAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "event", eventName);
        element.setExtensionElements(extensionElements);
    }

    private void deployAndStartProcess(BpmnModelInstance modelInstance) {
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
    }

    @After
    public void tearDown() {
        ModelExecutionContextExecutionListener.clear();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

