/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.camunda.bpm.engine.test.bpmn.executionlistener.CurrentActivityExecutionListener;
import org.camunda.bpm.engine.test.bpmn.executionlistener.ExampleExecutionListenerPojo;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ExecutionListenerTest {
    protected static final String PROCESS_KEY = "Process";
    protected static final String ERROR_CODE = "208";
    protected static final RuntimeException RUNTIME_EXCEPTION = new RuntimeException("Intended exception from delegate");
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    private static final String MESSAGE = "cancelMessage";
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER = ((BoundaryEventBuilder)((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().parallelGateway("fork").userTask("userTask1").serviceTask("sendTask").camundaExecutionListenerClass("start", SendMessageDelegate.class.getName())).camundaExpression("${true}")).endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).moveToLastGateway().userTask("userTask2").boundaryEvent("boundaryEvent").message("cancelMessage")).endEvent("endBoundaryEvent").moveToNode("userTask2").endEvent().done();
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_TWO_EXECUTION_START_LISTENER = ModifiableBpmnModelInstance.modify(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER).activityBuilder("sendTask").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName()).done();
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER_AND_SUB_PROCESS = ((UserTaskBuilder)((StartEventBuilder)((StartEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask").serviceTask("sendTask").camundaExecutionListenerClass("start", SendMessageDelegate.class.getName())).camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).camundaExpression("${true}")).endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done()).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("startSubProcess").interrupting(false)).camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).message("cancelMessage")).userTask("subProcessTask").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).endEvent("endSubProcess").done();

    @Before
    public void clearRecorderListener() {
        RecorderExecutionListener.clear();
    }

    @Before
    public void initServices() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.historyService = this.processEngineRule.getHistoryService();
        this.managementService = this.processEngineRule.getManagementService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
    }

    @Before
    public void resetListener() {
        ThrowBPMNErrorDelegate.reset();
        ThrowRuntimeExceptionDelegate.reset();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersProcess.bpmn20.xml"})
    public void testExecutionListenersOnAllPossibleElements() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", "businessKey123");
        String varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        Assert.assertNotNull((Object)varSetInExecutionListener);
        Assert.assertEquals((Object)"firstValue", (Object)varSetInExecutionListener);
        String businessKey = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeyInExecution");
        Assert.assertNotNull((Object)businessKey);
        Assert.assertEquals((Object)"businessKey123", (Object)businessKey);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        Assert.assertNotNull((Object)varSetInExecutionListener);
        Assert.assertEquals((Object)"secondValue", (Object)varSetInExecutionListener);
        ExampleExecutionListenerPojo myPojo = new ExampleExecutionListenerPojo();
        this.runtimeService.setVariable(processInstance.getId(), "myPojo", (Object)myPojo);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ExampleExecutionListenerPojo pojoVariable = (ExampleExecutionListenerPojo)this.runtimeService.getVariable(processInstance.getId(), "myPojo");
        Assert.assertNotNull((Object)pojoVariable.getReceivedEventName());
        Assert.assertEquals((Object)"end", (Object)pojoVariable.getReceivedEventName());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersStartEndEvent.bpmn20.xml"})
    public void testExecutionListenersOnStartEndEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)4L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"theStart", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"Start Event", (Object)recordedEvents.get(0).getActivityName());
        Assert.assertEquals((Object)"Start Event Listener", (Object)recordedEvents.get(0).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(0).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(0).isCanceled()).isFalse();
        Assert.assertEquals((Object)"noneEvent", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"None Event", (Object)recordedEvents.get(1).getActivityName());
        Assert.assertEquals((Object)"Intermediate Catch Event Listener", (Object)recordedEvents.get(1).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(1).isCanceled()).isFalse();
        Assert.assertEquals((Object)"signalEvent", (Object)recordedEvents.get(2).getActivityId());
        Assert.assertEquals((Object)"Signal Event", (Object)recordedEvents.get(2).getActivityName());
        Assert.assertEquals((Object)"Intermediate Throw Event Listener", (Object)recordedEvents.get(2).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(2).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(2).isCanceled()).isFalse();
        Assert.assertEquals((Object)"theEnd", (Object)recordedEvents.get(3).getActivityId());
        Assert.assertEquals((Object)"End Event", (Object)recordedEvents.get(3).getActivityName());
        Assert.assertEquals((Object)"End Event Listener", (Object)recordedEvents.get(3).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(3).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(3).isCanceled()).isFalse();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersFieldInjectionProcess.bpmn20.xml"})
    public void testExecutionListenerFieldInjection() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVar", "listening!");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", variables);
        Object varSetByListener = this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertNotNull((Object)varSetByListener);
        Assert.assertTrue((boolean)(varSetByListener instanceof String));
        Assert.assertEquals((Object)"Yes, I am listening!", (Object)varSetByListener);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersCurrentActivity.bpmn20.xml"})
    public void testExecutionListenerCurrentActivity() {
        CurrentActivityExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<CurrentActivityExecutionListener.CurrentActivity> currentActivities = CurrentActivityExecutionListener.getCurrentActivities();
        Assert.assertEquals((long)3L, (long)currentActivities.size());
        Assert.assertEquals((Object)"theStart", (Object)currentActivities.get(0).getActivityId());
        Assert.assertEquals((Object)"Start Event", (Object)currentActivities.get(0).getActivityName());
        Assert.assertEquals((Object)"noneEvent", (Object)currentActivities.get(1).getActivityId());
        Assert.assertEquals((Object)"None Event", (Object)currentActivities.get(1).getActivityName());
        Assert.assertEquals((Object)"theEnd", (Object)currentActivities.get(2).getActivityId());
        Assert.assertEquals((Object)"End Event", (Object)currentActivities.get(2).getActivityName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnBoundaryEvents.bpmn20.xml"})
    public void testOnBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job firstTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(firstTimer.getId());
        Job secondTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(secondTimer.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"timer1", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"start boundary listener", (Object)recordedEvents.get(0).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(0).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(0).isCanceled()).isFalse();
        Assert.assertEquals((Object)"timer2", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"end boundary listener", (Object)recordedEvents.get(1).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(1).isCanceled()).isFalse();
    }

    @Test
    @Deployment
    public void testScriptListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            Assert.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                Assert.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                Assert.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testScriptResourceListener.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/executionlistener/executionListener.groovy"})
    public void testScriptResourceListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            Assert.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                Assert.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                Assert.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Test
    @Deployment
    public void testExecutionListenerOnTerminateEndEvent() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(0).getEventName());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnCancellingBoundaryEvent.bpmn"})
    public void testOnCancellingBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job timer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(timer.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assertions.assertThat(recordedEvents).hasSize(1);
        Assert.assertEquals((Object)"UserTask_1", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(0).getEventName());
        Assertions.assertThat((boolean)recordedEvents.get(0).isCanceled()).isTrue();
    }

    @Test
    public void testServiceTaskExecutionListenerCall() {
        this.testRule.deploy(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(0).getActivityId());
    }

    @Test
    public void testServiceTaskTwoExecutionListenerCall() {
        this.testRule.deploy(PROCESS_SERVICE_TASK_WITH_TWO_EXECUTION_START_LISTENER);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"sendTask", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(1).getActivityId());
    }

    @Test
    public void testServiceTaskExecutionListenerCallAndSubProcess() {
        this.testRule.deploy(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER_AND_SUB_PROCESS);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)4L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"startSubProcess", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"subProcessTask", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"sendTask", (Object)recordedEvents.get(2).getActivityId());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(3).getActivityId());
    }

    @Test
    public void testEndExecutionListenerIsCalledOnlyOnce() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalProcessKey").startEvent().userTask().camundaExecutionListenerClass("end", SetVariableDelegate.class.getName())).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalProcessKey").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(true)).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.testRule.deploy(modelInstance);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalProcessKey");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testMultiInstanceCancelation.bpmn20.xml"})
    public void testMultiInstanceCancelationDoesNotAffectEndListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("MultiInstanceCancelation");
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.taskService.complete(((Task)tasks.get(3)).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance endVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("finished").singleResult();
            Assert.assertNotNull((Object)endVariable);
            Assert.assertNotNull((Object)endVariable.getValue());
            Assert.assertTrue((boolean)Boolean.valueOf(String.valueOf(endVariable.getValue())));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testMultiInstanceCancelation.bpmn20.xml"})
    public void testProcessInstanceCancelationNoticedInEndListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("MultiInstanceCancelation");
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "myReason");
        this.testRule.assertProcessEnded(processInstance.getId());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance endVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("canceled").singleResult();
            Assert.assertNotNull((Object)endVariable);
            Assert.assertNotNull((Object)endVariable.getValue());
            Assert.assertTrue((boolean)Boolean.valueOf(String.valueOf(endVariable.getValue())));
        }
    }

    @Test
    public void testThrowExceptionInStartListenerServiceTaskWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("start", true);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from delegate");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testThrowExceptionInEndListenerAndServiceTaskWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("end", true);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from delegate");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testThrowExceptionInEndListenerAndServiceTaskWithCatchException() {
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("end", true, true);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught(true);
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowExceptionInEndListenerAndSubprocessWithCatchException() {
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("end", true, true);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught(true);
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowExceptionInEndListenerAndEventSubprocessWithCatchException() {
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("end", true, true);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught(true);
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerServiceTaskWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerAndSubprocessWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerAndEventSubprocessWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerAndServiceTaskWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerAndSubprocessWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerAndEventSubprocessWithCatch() {
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInTakeListenerAndEventSubprocessWithCatch() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((UserTaskBuilder)processBuilder.startEvent().userTask("userTask1").sequenceFlowId("flow1")).userTask("afterListener").endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)model.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(ThrowBPMNErrorDelegate.class.getName());
        ((SequenceFlow)model.getModelElementById("flow1")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOfStartEventAndEventSubprocessWithCatch() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((StartEventBuilder)processBuilder.startEvent().camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).userTask("afterListener").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOfStartEventAndSubprocessWithCatch() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).userTask("afterListener").endEvent().subProcessDone().boundaryEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("sub").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowBpmnErrorInEndListenerOfLastEventAndEventProcessWithCatch() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)processBuilder.startEvent().userTask("userTask1").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("end", ThrowBPMNErrorDelegate.class.getName())).done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Task afterCatch = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterCatch);
        Assert.assertEquals((Object)"afterCatch", (Object)afterCatch.getName());
        Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        this.taskService.complete(afterCatch.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerOfLastEventAndServiceTaskWithCatch() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("end", ThrowBPMNErrorDelegate.class.getName())).boundaryEvent().error(ERROR_CODE)).userTask("afterCatch").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOfLastEventAndServiceTaskWithCatch() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).boundaryEvent().error(ERROR_CODE)).userTask("afterCatch").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerOfLastEventAndSubprocessWithCatch() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("end", ThrowBPMNErrorDelegate.class.getName())).boundaryEvent().error(ERROR_CODE)).userTask("afterCatch").moveToActivity("sub").userTask("afterSub").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOfLastEventAndSubprocessWithCatch() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).boundaryEvent().error(ERROR_CODE)).userTask("afterCatch").moveToActivity("sub").userTask("afterSub").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerServiceTaskAndEndListener() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).camundaExecutionListenerClass("end", SetsVariableDelegate.class.getName())).camundaExpression("${true}")).boundaryEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("throw").userTask("afterService").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("foo").singleResult()).getValue());
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOfStartEventAndCallActivity() {
        BpmnModelInstance subprocess = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"subprocess").startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).camundaExpression("${true}")).userTask("afterService").done();
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance parent = ((CallActivityBuilder)processBuilder.startEvent().callActivity().calledElement("subprocess")).userTask("afterCallActivity").done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(parent, subprocess);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerInConcurrentExecutionAndEventSubprocessWithCatch() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)processBuilder.startEvent().parallelGateway("fork").userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).camundaExpression("${true}")).userTask("afterService").endEvent().moveToLastGateway().userTask("userTask2").done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    public void testThrowBpmnErrorInStartExpressionListenerAndEventSubprocessWithCatch() {
        this.processEngineRule.getProcessEngineConfiguration().getBeans().put("myListener", new ThrowBPMNErrorDelegate());
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)processBuilder.startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerExpression("start", "${myListener.notify(execution)}")).camundaExpression("${true}")).userTask("afterService").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyErrorGotCaught();
        this.verifyActivityCanceled("throw");
    }

    @Test
    @Deployment
    public void testThrowBpmnErrorInEndScriptListenerAndSubprocessWithCatch() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        Assert.assertEquals((Object)"afterCatch", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        this.verifyActivityCanceled("task1");
    }

    @Test
    public void testThrowUncaughtBpmnErrorFromEndListenerShouldNotTriggerListenerAgain() {
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("end", ThrowBPMNErrorDelegate.class.getName())).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        this.verifyActivityEnded("throw");
    }

    @Test
    public void testThrowUncaughtBpmnErrorFromStartListenerShouldNotTriggerListenerAgain() {
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExpression("${true}")).camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        this.verifyActivityEnded("throw");
    }

    @Test
    public void testThrowBpmnErrorInEndListenerMessageCorrelationShouldNotTriggerPropagation() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").userTask("taskWithListener").camundaExecutionListenerClass("end", ThrowBPMNErrorDelegate.class.getName())).boundaryEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent().subProcessDone().boundaryEvent("message").message("foo")).userTask("afterMessage").endEvent("endEvent").moveToActivity("sub").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        Assert.assertEquals((Object)"taskWithListener", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        try {
            this.runtimeService.correlateMessage("foo");
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("business error"));
            Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        }
    }

    @Test
    public void testThrowBpmnErrorInStartListenerOnModificationShouldNotTriggerPropagation() {
        BpmnModelInstance model = ((BoundaryEventBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").camundaExecutionListenerClass("start", ThrowBPMNErrorDelegate.class.getName())).embeddedSubProcess().startEvent("inSub").serviceTask("throw").camundaExpression("${true}")).boundaryEvent("errorEvent1").error(ERROR_CODE)).subProcessDone().boundaryEvent("errorEvent2").error(ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("sub").userTask("afterSub").endEvent().done();
        DeploymentWithDefinitions deployment = this.testRule.deploy(model);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).startBeforeActivity("throw")).processInstanceIds(new String[]{processInstance.getId()}).execute()).isInstanceOf(BpmnError.class)).hasMessageContaining("business error");
    }

    @Test
    public void testThrowBpmnErrorInProcessStartListenerShouldNotTriggerPropagation() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = processBuilder.startEvent().userTask("afterThrow").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        CamundaExecutionListener listener = (CamundaExecutionListener)model.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("start");
        listener.setCamundaClass(ThrowBPMNErrorDelegate.class.getName());
        ((Process)model.getModelElementById(PROCESS_KEY)).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.testRule.deploy(model);
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("business error"));
            Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        }
    }

    @Test
    public void testThrowBpmnErrorInProcessEndListenerShouldNotTriggerPropagation() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = processBuilder.startEvent().endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        CamundaExecutionListener listener = (CamundaExecutionListener)model.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("end");
        listener.setCamundaClass(ThrowBPMNErrorDelegate.class.getName());
        ((Process)model.getModelElementById(PROCESS_KEY)).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.testRule.deploy(model);
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("business error"));
            Assert.assertEquals((long)1L, (long)ThrowBPMNErrorDelegate.INVOCATIONS);
        }
    }

    protected BpmnModelInstance createModelWithCatchInServiceTaskAndListener(String eventName) {
        return this.createModelWithCatchInServiceTaskAndListener(eventName, false);
    }

    protected BpmnModelInstance createModelWithCatchInServiceTaskAndListener(String eventName, boolean throwException) {
        return this.createModelWithCatchInServiceTaskAndListener(eventName, throwException, false);
    }

    protected BpmnModelInstance createModelWithCatchInServiceTaskAndListener(String eventName, boolean throwException, boolean catchException) {
        return ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass(eventName, throwException ? ThrowRuntimeExceptionDelegate.class : ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).boundaryEvent("errorEvent").error(catchException ? RUNTIME_EXCEPTION.getClass().getName() : ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("throw").userTask("afterService").endEvent().done();
    }

    protected BpmnModelInstance createModelWithCatchInSubprocessAndListener(String eventName) {
        return this.createModelWithCatchInSubprocessAndListener(eventName, false, false);
    }

    protected BpmnModelInstance createModelWithCatchInSubprocessAndListener(String eventName, boolean throwException, boolean catchException) {
        return ((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").serviceTask("throw").camundaExecutionListenerClass(eventName, throwException ? ThrowRuntimeExceptionDelegate.class : ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).userTask("afterService").endEvent().subProcessDone().boundaryEvent("errorEvent").error(catchException ? RUNTIME_EXCEPTION.getClass().getName() : ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("sub").userTask("afterSub").endEvent().done();
    }

    protected BpmnModelInstance createModelWithCatchInEventSubprocessAndListener(String eventName) {
        return this.createModelWithCatchInEventSubprocessAndListener(eventName, false, false);
    }

    protected BpmnModelInstance createModelWithCatchInEventSubprocessAndListener(String eventName, boolean throwException, boolean catchException) {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)processBuilder.startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass(eventName, throwException ? ThrowRuntimeExceptionDelegate.class : ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).userTask("afterService").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(catchException ? RUNTIME_EXCEPTION.getClass().getName() : ERROR_CODE)).userTask("afterCatch").endEvent();
        return model;
    }

    protected void verifyErrorGotCaught() {
        this.verifyErrorGotCaught(false);
    }

    protected void verifyErrorGotCaught(boolean useExceptionDelegate) {
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        Assert.assertEquals((Object)"afterCatch", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        Assert.assertEquals((long)1L, (long)(useExceptionDelegate ? (long)ThrowRuntimeExceptionDelegate.INVOCATIONS : (long)ThrowBPMNErrorDelegate.INVOCATIONS));
    }

    protected void verifyActivityCanceled(String activityName) {
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assertions.assertThat((long)this.historyService.createHistoricActivityInstanceQuery().activityName(activityName).canceled().count()).isEqualTo(1L);
        }
    }

    protected void verifyActivityEnded(String activityName) {
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assertions.assertThat((long)this.historyService.createHistoricActivityInstanceQuery().activityName(activityName).completeScope().count()).isEqualTo(1L);
        }
    }

    public static class SetsVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("foo", (Object)"bar");
        }
    }

    public static class ThrowRuntimeExceptionDelegate
    implements ExecutionListener {
        public static int INVOCATIONS = 0;

        public void notify(DelegateExecution execution) throws Exception {
            ++INVOCATIONS;
            throw RUNTIME_EXCEPTION;
        }

        public static void reset() {
            INVOCATIONS = 0;
        }
    }

    public static class ThrowBPMNErrorDelegate
    implements ExecutionListener {
        public static int INVOCATIONS = 0;

        public void notify(DelegateExecution execution) throws Exception {
            ++INVOCATIONS;
            throw new BpmnError(ExecutionListenerTest.ERROR_CODE, "business error");
        }

        public static void reset() {
            INVOCATIONS = 0;
        }
    }

    public static class SendMessageDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            runtimeService.correlateMessage(ExecutionListenerTest.MESSAGE);
        }
    }
}

