/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.sequenceflow;

import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SequenceFlowTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testTakeAllOutgoingFlowsFromNonScopeTask() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("task2").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("task3").count());
        for (Task followUpTask : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(followUpTask.getId());
        }
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testTakeAllOutgoingFlowsFromScopeTask() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("task2").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("task3").count());
        for (Task followUpTask : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(followUpTask.getId());
        }
        this.testRule.assertProcessEnded(instance.getId());
    }
}

