/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.servicetask;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.test.bpmn.common.AbstractProcessEngineServicesAccessTest;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.Task;

public class JavaDelegateProcessEngineServicesAccessTest
extends AbstractProcessEngineServicesAccessTest {
    @Override
    protected Class<?> getTestServiceAccessibleClass() {
        return AccessServicesJavaDelegate.class;
    }

    @Override
    protected Class<?> getQueryClass() {
        return PerformQueryJavaDelegate.class;
    }

    @Override
    protected Class<?> getStartProcessInstanceClass() {
        return StartProcessJavaDelegate.class;
    }

    @Override
    protected Class<?> getProcessEngineStartProcessClass() {
        return ProcessEngineStartProcessJavaDelegate.class;
    }

    @Override
    protected Task createModelAccessTask(BpmnModelInstance modelInstance, Class<?> delegateClass) {
        ServiceTask serviceTask = (ServiceTask)modelInstance.newInstance(ServiceTask.class);
        serviceTask.setId("serviceTask");
        serviceTask.setCamundaClass(delegateClass.getName());
        return serviceTask;
    }

    public static class ProcessEngineStartProcessJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngine());
        }
    }

    public static class StartProcessJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngineServices());
        }
    }

    public static class PerformQueryJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanPerformQuery(execution.getProcessEngineServices());
        }
    }

    public static class AccessServicesJavaDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            AbstractProcessEngineServicesAccessTest.assertCanAccessServices(execution.getProcessEngineServices());
        }
    }
}

