/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.subprocess;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class InterruptingEventSubProcessTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/InterruptingEventSubProcessTest.testCancelEventSubscriptions.bpmn"})
    @Test
    public void testCancelEventSubscriptionsWhenReceivingAMessage() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskBeforeInterruptingEventSuprocess", (Object)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        Assert.assertEquals((long)2L, (long)eventSubscriptions.size());
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterMessageStartEvent", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        try {
            this.runtimeService.signalEventReceived("newSignal", pi.getId());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/subprocess/InterruptingEventSubProcessTest.testCancelEventSubscriptions.bpmn"})
    @Test
    public void testCancelEventSubscriptionsWhenReceivingASignal() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskBeforeInterruptingEventSuprocess", (Object)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        Assert.assertEquals((long)2L, (long)eventSubscriptions.size());
        this.runtimeService.signalEventReceived("newSignal", pi.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"tastAfterSignalStartEvent", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        try {
            this.runtimeService.messageEventReceived("newMessage", pi.getId());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testCancelTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        JobQuery jobQuery = this.managementService.createJobQuery().timers();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskBeforeInterruptingEventSuprocess", (Object)task.getTaskDefinitionKey());
        Job timer = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)timer);
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterMessageStartEvent", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testKeepCompensation() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskBeforeInterruptingEventSuprocess", (Object)task.getTaskDefinitionKey());
        List eventSubscriptions = eventSubscriptionQuery.list();
        Assert.assertEquals((long)2L, (long)eventSubscriptions.size());
        this.runtimeService.messageEventReceived("newMessage", pi.getId());
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterMessageStartEvent", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)1L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimeCycle() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery();
        Assert.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
        JobQuery jobQuery = this.managementService.createJobQuery().timers();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"eventSubProcessTask", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }
}

