/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class CompetingTransactionsOptimisticLockingTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Deployment
    @Test
    @RequiredDatabase(excludes={"postgres"})
    public void testCompetingTransactionsOptimisticLocking() {
        this.runtimeService.startProcessInstanceByKey("competingTransactionsProcess");
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task firstTask = "task1-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        Task secondTask = "task2-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        TransactionThread thread1 = new TransactionThread(firstTask.getId());
        thread1.startAndWaitUntilControlIsReturned();
        TransactionThread thread2 = new TransactionThread(secondTask.getId());
        thread2.startAndWaitUntilControlIsReturned();
        thread2.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)thread2.exception));
        thread1.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)thread1.exception));
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assert.assertEquals(OptimisticLockingException.class, ((Object)((Object)thread1.exception)).getClass());
        } else {
            Assert.assertEquals(CrdbTransactionRetryException.class, ((Object)((Object)thread1.exception)).getClass());
        }
    }

    public class TransactionThread
    extends ControllableThread {
        String taskId;
        ProcessEngineException exception;

        public TransactionThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingTransactionsOptimisticLockingTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.taskId, null)));
            }
            catch (ProcessEngineException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends.");
        }
    }
}

