/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency.partitioning;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Test;

public class CompetingHistoricVariableInstancePartitioningTest
extends AbstractPartitioningTest {
    protected final String VARIABLE_NAME = "aVariableName";
    protected final String VARIABLE_VALUE = "aVariableValue";
    protected final String ANOTHER_VARIABLE_VALUE = "anotherVariableValue";

    @Test
    public void shouldSuppressOleOnConcurrentFetchAndDelete() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK, (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue")).getId();
        ConcurrencyTestHelper.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(processInstanceId));
        asyncThread.reportInterrupts();
        asyncThread.waitForSync();
        this.commandExecutor.execute(commandContext -> {
            HistoricVariableInstanceEntity historicVariableInstanceEntity = (HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            commandContext.getDbEntityManager().delete((DbEntity)historicVariableInstanceEntity);
            return null;
        });
        Assertions.assertThat((Object)((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult())).isNull();
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assertions.assertThat((String)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getName()).isEqualTo((Object)"aVariableName");
            Assertions.assertThat((Object)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getValue()).isEqualTo((Object)"anotherVariableValue");
        } else {
            Assertions.assertThat((Throwable)asyncThread.getException()).isInstanceOf(CrdbTransactionRetryException.class);
        }
    }

    public class AsyncThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        String processInstanceId;

        AsyncThread(String processInstanceId) {
            this.processInstanceId = processInstanceId;
        }

        public Void execute(CommandContext commandContext) {
            ((HistoricVariableInstance)CompetingHistoricVariableInstancePartitioningTest.this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRuntimeService().setVariable(this.processInstanceId, "aVariableName", (Object)"anotherVariableValue");
            return null;
        }
    }
}

