/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.errorcode.conf;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.camunda.bpm.engine.impl.errorcode.ExceptionCodeProvider;
import org.camunda.bpm.engine.test.errorcode.FailingJavaDelegateWithCustomException;
import org.camunda.bpm.engine.test.errorcode.FailingJavaDelegateWithErrorCode;
import org.camunda.bpm.engine.test.errorcode.FailingJavaDelegateWithOleAndErrorCode;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CustomErrorCodeProviderTest {
    protected static int PROVIDED_CUSTOM_CODE = 33333;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setCustomExceptionCodeProvider(new ExceptionCodeProvider(){

        public Integer provideCode(SQLException sqlException) {
            return PROVIDED_CUSTOM_CODE;
        }

        public Integer provideCode(ProcessEngineException processEngineException) {
            return PROVIDED_CUSTOM_CODE;
        }
    }));
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.cmd"}).level(Level.WARN);
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected IdentityService identityService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void clear() {
        this.engineRule.getIdentityService().deleteUser("kermit");
    }

    @Test
    public void shouldOverrideProvidedExceptionCode1() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        Throwable exception = Assertions.catchThrowable(() -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)22222)));
        Assertions.assertThat((int)((ProcessEngineException)exception).getCode()).isEqualTo(22222);
    }

    @Test
    public void shouldOverrideProvidedExceptionCode2() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        Throwable exception = Assertions.catchThrowable(() -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)20000)));
        Assertions.assertThat((int)((ProcessEngineException)exception).getCode()).isEqualTo(20000);
    }

    @Test
    public void shouldOverrideProvidedExceptionCode3() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        Throwable exception = Assertions.catchThrowable(() -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)39999)));
        Assertions.assertThat((int)((ProcessEngineException)exception).getCode()).isEqualTo(39999);
    }

    @Test
    public void shouldOverrideCodeFromDelegationCodeWithBuiltinCode() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithOleAndErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)40000));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.OPTIMISTIC_LOCKING.getCode()});
        Assertions.assertThat((String)((ILoggingEvent)this.loggingRule.getLog().get(0)).getMessage()).contains(new CharSequence[]{"Falling back to built-in code"});
    }

    @Test
    public void shouldOverrideCodeZeroWithCustomCode() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)0));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{PROVIDED_CUSTOM_CODE});
    }

    @Test
    public void shouldResetReservedCodeFromDelegationCode1() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)1));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
        Assertions.assertThat((String)((ILoggingEvent)this.loggingRule.getLog().get(0)).getMessage()).contains(new CharSequence[]{"Falling back to default error code 0."});
    }

    @Test
    public void shouldResetReservedCodeFromDelegationCode2() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)19999));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
        Assertions.assertThat((String)((ILoggingEvent)this.loggingRule.getLog().get(0)).getMessage()).contains(new CharSequence[]{"Falling back to default error code 0."});
    }

    @Test
    public void shouldResetReservedCodeFromDelegationCode3() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)40000));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
        Assertions.assertThat((String)((ILoggingEvent)this.loggingRule.getLog().get(0)).getMessage()).contains(new CharSequence[]{"Falling back to default error code 0."});
    }

    @Test
    public void shouldProvideCustomCodeFromDelegationCodeWithCustomException() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithCustomException.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)22222));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{22222});
    }

    @Test
    public void shouldHaveSubordinationToBuiltinCode() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testRule.deploy(modelInstance);
        String businessKey = this.generateString(1000);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("process", businessKey)).isInstanceOf(ProcessEngineException.class)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.COLUMN_SIZE_TOO_SMALL.getCode()});
    }

    protected String generateString(int size) {
        return new String(new char[size]).replace('\u0000', 'a');
    }
}

