/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.errorcode.conf;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.camunda.bpm.engine.test.errorcode.FailingJavaDelegateWithErrorCode;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ExceptionCodeDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setDisableExceptionCode(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected IdentityService identityService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void clear() {
        this.engineRule.getIdentityService().deleteUser("kermit");
    }

    @Test
    public void shouldReturnDefaultErrorCodeWhenColumnSizeTooSmall() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testRule.deploy(modelInstance);
        String businessKey = this.generateString(1000);
        Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("process", businessKey)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
    }

    @Test
    public void shouldReturnDefaultErrorCodeWhenOptimisticLockingExceptionThrown() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        user2.setFirstName("name two");
        Assertions.assertThatThrownBy(() -> this.identityService.saveUser(user2)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
    }

    @Test
    public void shouldPassCodeFromDelegationCode() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)999999));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{999999});
    }

    @Test
    public void shouldPassReservedCodeFromDelegationCode() {
        BpmnModelInstance myProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().serviceTask().camundaClass(FailingJavaDelegateWithErrorCode.class)).endEvent().done();
        this.testRule.deploy(myProcess);
        ThrowableAssert.ThrowingCallable callable = () -> this.runtimeService.startProcessInstanceByKey("foo", (Map)Variables.putValue((String)"code", (Object)1000));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).extracting(new String[]{"code"}).contains(new Object[]{1000});
    }

    protected String generateString(int size) {
        return new String(new char[size]).replace('\u0000', 'a');
    }
}

