/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Arrays;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RequiredHistoryLevel(value="audit")
public class HistoricIncidentAuditTest {
    private static SessionFactory sessionFactory = (SessionFactory)Mockito.spy((Object)new MockSessionFactory());
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setCustomSessionFactories(Arrays.asList(sessionFactory)));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void shouldNotQueryForHistoricJobLogWhenSettingJobToZeroRetries() {
        BpmnModelInstance modelInstance = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(modelInstance);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        runtimeService.startProcessInstanceByKey("process");
        ManagementService managementService = this.engineRule.getManagementService();
        Job job = (Job)managementService.createJobQuery().singleResult();
        Mockito.reset((Object[])new SessionFactory[]{sessionFactory});
        managementService.setJobRetries(job.getId(), 0);
        ((SessionFactory)Mockito.verify((Object)sessionFactory, (VerificationMode)Mockito.never())).openSession();
    }

    @Test
    public void shouldNotQueryForHistoricJobLogWhenSettingExternalTaskToZeroRetries() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaExternalTask("topic")).endEvent().done();
        this.testRule.deploy(modelInstance);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        runtimeService.startProcessInstanceByKey("process");
        ExternalTaskService externalTaskService = this.engineRule.getExternalTaskService();
        ExternalTask externalTask = (ExternalTask)externalTaskService.createExternalTaskQuery().singleResult();
        Mockito.reset((Object[])new SessionFactory[]{sessionFactory});
        externalTaskService.setRetries(externalTask.getId(), 0);
        ((SessionFactory)Mockito.verify((Object)sessionFactory, (VerificationMode)Mockito.never())).openSession();
    }

    public static class MockSessionFactory
    implements SessionFactory {
        public Class<?> getSessionType() {
            return HistoricJobLogManager.class;
        }

        public Session openSession() {
            return new HistoricJobLogManager();
        }
    }
}

