/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogWithoutUserTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testAssignTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testClaimTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.claim(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Test
    public void testCreateTask() {
        Task task = this.taskService.newTask("a-task-id");
        this.taskService.saveTask(task);
        this.verifyNoUserOperationLogged();
        this.taskService.deleteTask("a-task-id", true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDelegateTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.delegateTask(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testResolveTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetOwnerTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setOwner(taskId, "demo");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetPriorityTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setPriority(taskId, 60);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateTask() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setCaseInstanceId("a-case-instance-id");
        this.taskService.saveTask(task);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testActivateProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.activateProcessInstanceById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.suspendProcessInstanceById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testActivateJobDefinition() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((JobDefinition)this.managementService.createJobDefinitionQuery().singleResult()).getId();
        this.managementService.activateJobByJobDefinitionId(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSuspendJobDefinition() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((JobDefinition)this.managementService.createJobDefinitionQuery().singleResult()).getId();
        this.managementService.suspendJobByJobDefinitionId(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testActivateJob() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.activateJobById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSuspendJob() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.suspendJobById(id);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetJobRetries() {
        this.runtimeService.startProcessInstanceByKey("oneFailingServiceTaskProcess");
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(id, 5);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testActivateProcessDefinition() {
        this.repositoryService.activateProcessDefinitionByKey(PROCESS_KEY);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendProcessDefinition() {
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_KEY);
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testModifyProcessInstance() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.createProcessInstanceModification(id).cancelAllForActivity("theTask").execute();
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariable() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariable() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.runtimeService.removeVariable(id, "aVariable");
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteHistoricVariable() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.runtimeService.deleteProcessInstance(id, "none");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        String historicVariableId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(historicVariableId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteAllHistoricVariables() {
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.setVariable(id, "aVariable", (Object)"aValue");
        this.runtimeService.deleteProcessInstance(id, "none");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(id);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.verifyNoUserOperationLogged();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testQueryDeleteVariableHistoryOperationOnCase() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)1);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)2);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)3);
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verifyNoUserOperationLogged();
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testQueryDeleteVariableHistoryOperationOnStandaloneTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue2");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verifyNoUserOperationLogged();
        this.taskService.deleteTask(task.getId(), true);
    }

    protected void verifyNoUserOperationLogged() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
    }
}

