/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobAcquisitionTest {
    protected static final int DEFAULT_NUM_JOBS_TO_ACQUIRE = 3;
    protected ControllableJobExecutor jobExecutor1;
    protected ControllableJobExecutor jobExecutor2;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread1;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread2;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJobExecutor((JobExecutor)new ControllableJobExecutor()));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.jobExecutor1 = (ControllableJobExecutor)((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getJobExecutor();
        this.jobExecutor1.setMaxJobsPerAcquisition(3);
        this.acquisitionThread1 = this.jobExecutor1.getAcquisitionThreadControl();
        this.jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.engineRule.getProcessEngine());
        this.jobExecutor2.setMaxJobsPerAcquisition(3);
        this.acquisitionThread2 = this.jobExecutor2.getAcquisitionThreadControl();
    }

    @After
    public void tearDown() throws Exception {
        this.jobExecutor1.shutdown();
        this.jobExecutor2.shutdown();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testJobLockingFailure() {
        int numberOfInstances = 3;
        for (int i = 0; i < numberOfInstances; ++i) {
            this.engineRule.getRuntimeService().startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().active().count());
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)jobExecutor1WaitEvents.size());
        Assert.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(0).getTimeBetweenAcquisitions());
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)jobExecutor2WaitEvents.size());
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assert.assertEquals((long)0L, (long)jobExecutor2WaitEvents.get(0).getTimeBetweenAcquisitions());
        } else {
            Assert.assertEquals((long)5000L, (long)jobExecutor2WaitEvents.get(0).getTimeBetweenAcquisitions());
        }
    }
}

