/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobDefinitionRedeploymentTest {
    @Parameterized.Parameter
    public String processDefinitionResource;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Parameterized.Parameters(name="{index}: process definition = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerStartEvent.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerBoundaryEvent.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testMultipleTimerBoundaryEvents.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testEventBasedGateway.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testTimerIntermediateEvent.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuation.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuationOfMultiInstance.bpmn20.xml"}, {"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuationOfActivityWrappedInMultiInstance.bpmn20.xml"});
    }

    @Before
    public void initServices() {
        this.managementService = this.rule.getManagementService();
        this.repositoryService = this.rule.getRepositoryService();
        this.runtimeService = this.rule.getRuntimeService();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.rule.getProcessEngine().getProcessEngineConfiguration();
    }

    @Test
    public void testJobDefinitionsAfterRedeploment() {
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(this.processDefinitionResource).deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        Set<String> jobDefinitionIds = this.getJobDefinitionIds(jobDefinitions);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        Assert.assertEquals((long)jobDefinitions.size(), (long)this.managementService.createJobDefinitionQuery().count());
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            Assert.assertTrue((boolean)jobDefinitionIds.contains(job.getJobDefinitionId()));
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    protected Set<String> getJobDefinitionIds(List<JobDefinition> jobDefinitions) {
        HashSet<String> definitionIds = new HashSet<String>();
        for (JobDefinition definition : jobDefinitions) {
            definitionIds.add(definition.getId());
        }
        return definitionIds;
    }
}

