/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DurationHelperTest {
    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void shouldNotExceedNumber() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(0L));
        DurationHelper dh = new DurationHelper("R2/PT10S");
        ClockUtil.setCurrentTime((Date)new Date(15000L));
        TestCase.assertEquals((long)20000L, (long)dh.getDateAfter().getTime());
        ClockUtil.setCurrentTime((Date)new Date(30000L));
        Assert.assertNull((Object)dh.getDateAfter());
    }

    @Test
    public void shouldNotExceedNumberPeriods() throws Exception {
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:00"));
        DurationHelper dh = new DurationHelper("R2/1970-01-01T00:00:00/1970-01-01T00:00:10");
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:15"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:20"), (Object)dh.getDateAfter());
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:30"));
        Assert.assertNull((Object)dh.getDateAfter());
    }

    @Test
    public void shouldNotExceedNumberNegative() throws Exception {
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:00"));
        DurationHelper dh = new DurationHelper("R2/PT10S/1970-01-01T00:00:50");
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:20"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:30"), (Object)dh.getDateAfter());
        ClockUtil.setCurrentTime((Date)this.parse("19700101-00:00:35"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:40"), (Object)dh.getDateAfter());
    }

    @Test
    public void shouldNotExceedNumberWithStartDate() throws Exception {
        DurationHelper dh = new DurationHelper("R2/PT10S", new Date(0L));
        TestCase.assertEquals((long)20000L, (long)dh.getDateAfter(new Date(15000L)).getTime());
        Assert.assertNull((Object)dh.getDateAfter(new Date(30000L)));
    }

    @Test
    public void shouldNotExceedNumberPeriodsWithStartDate() throws Exception {
        DurationHelper dh = new DurationHelper("R2/1970-01-01T00:00:00/1970-01-01T00:00:10", this.parse("19700101-00:00:00"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:20"), (Object)dh.getDateAfter(this.parse("19700101-00:00:15")));
        Assert.assertNull((Object)dh.getDateAfter(this.parse("19700101-00:00:30")));
    }

    @Test
    public void shouldNotExceedNumberNegativeWithStartDate() throws Exception {
        DurationHelper dh = new DurationHelper("R2/PT10S/1970-01-01T00:00:50", this.parse("19700101-00:00:00"));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:30"), (Object)dh.getDateAfter(this.parse("19700101-00:00:20")));
        TestCase.assertEquals((Object)this.parse("19700101-00:00:40"), (Object)dh.getDateAfter(this.parse("19700101-00:00:35")));
    }

    @Test
    public void shouldParseAllSupportedISO8601DurationPatterns() throws Exception {
        DurationHelper PnYnMnDTnHnMnS = new DurationHelper("P1Y5M21DT19H47M55S", this.parse("19700101-00:00:00"));
        DurationHelper PnW = new DurationHelper("P2W", this.parse("19700101-00:00:00"));
        Assertions.assertThat((Date)PnYnMnDTnHnMnS.getDateAfter()).isEqualTo((Object)this.parse("19710622-19:47:55"));
        Assertions.assertThat((Date)PnW.getDateAfter()).isEqualTo((Object)this.parse("19700115-00:00:00"));
    }

    @Test
    public void shouldParseP4W() throws Exception {
        DurationHelper PnW = new DurationHelper("P4W", this.parse("19700101-00:00:00"));
        Assertions.assertThat((Date)PnW.getDateAfter()).isEqualTo((Object)this.parse("19700129-00:00:00"));
    }

    @Test
    public void shouldParseP5W() throws Exception {
        DurationHelper PnW = new DurationHelper("P5W", this.parse("19700101-00:00:00"));
        Assertions.assertThat((Date)PnW.getDateAfter()).isEqualTo((Object)this.parse("19700205-00:00:00"));
    }

    @Test
    public void shouldParseP22W() throws Exception {
        DurationHelper PnW = new DurationHelper("P22W", this.parse("19700101-00:00:00"));
        Assertions.assertThat((Date)PnW.getDateAfter()).isEqualTo((Object)this.parse("19700604-00:00:00"));
    }

    private Date parse(String str) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        return simpleDateFormat.parse(str);
    }
}

