/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.identity;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.identity.PasswordPolicyResult;
import org.camunda.bpm.engine.identity.PasswordPolicyRule;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyDigitRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyLengthRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyLowerCaseRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicySpecialCharacterRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyUpperCaseRuleImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DefaultPasswordPolicyTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected IdentityService identityService;
    protected PasswordPolicy policy = new DefaultPasswordPolicyImpl();

    @Before
    public void init() {
        this.identityService = this.rule.getIdentityService();
        this.rule.getProcessEngineConfiguration().setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl()).setEnablePasswordPolicy(true);
    }

    @After
    public void resetProcessEngineConfig() {
        this.rule.getProcessEngineConfiguration().setPasswordPolicy(null).setEnablePasswordPolicy(false);
    }

    @Test
    public void testGoodPassword() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPas$w0rd");
        MatcherAssert.assertThat((Object)result.getViolatedRules().size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)result.getFulfilledRules().size(), (Matcher)Is.is((Object)6));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCheckValidPassword_WithoutPassingPolicy() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy("LongPas$w0rd");
        MatcherAssert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testPasswordWithoutLowerCase() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LONGPAS$W0RD");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_LOWERCASE"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyLowerCaseRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutUpperCase() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "longpas$w0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_UPPERCASE"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyUpperCaseRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutSpecialChar() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPassw0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_SPECIAL"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicySpecialCharacterRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutDigit() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPas$word");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_DIGIT"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyDigitRuleImpl.class));
    }

    @Test
    public void testShortPassword() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "Pas$w0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_LENGTH"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyLengthRuleImpl.class));
    }

    @Test
    public void shouldThrowNullValueException_policyNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.checkPasswordAgainstPolicy(null, "Pas$w0rd")).isInstanceOf(NullValueException.class)).hasMessageContaining("policy is null");
    }

    @Test
    public void shouldThrowNullValueException_passwordNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.checkPasswordAgainstPolicy(this.policy, null)).isInstanceOf(NullValueException.class)).hasMessageContaining("password is null");
    }

    @Test
    public void shouldGetPasswordPolicy() {
        PasswordPolicy passwordPolicy = this.identityService.getPasswordPolicy();
        MatcherAssert.assertThat((Object)passwordPolicy, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldUpdateUserDetailsWithoutPolicyCheck() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("john@doe.com");
        user.setPassword("Passw0rds!");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        user.setEmail("jane@donnel.com");
        user.setFirstName("Jane");
        user.setLastName("Donnel");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        MatcherAssert.assertThat((Object)user.getFirstName(), (Matcher)Is.is((Object)"Jane"));
        MatcherAssert.assertThat((Object)user.getLastName(), (Matcher)Is.is((Object)"Donnel"));
        MatcherAssert.assertThat((Object)user.getEmail(), (Matcher)Is.is((Object)"jane@donnel.com"));
        MatcherAssert.assertThat((Object)this.identityService.checkPassword("johndoe", "Passw0rds!"), (Matcher)Is.is((Object)true));
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void shouldCheckUserRuleWithPolicyPassed() {
        User user = this.identityService.newUser("myUserId");
        String candidatePassword = "myUserId";
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, candidatePassword, user);
        Assertions.assertThat((List)result.getViolatedRules()).extracting("placeholder").contains(new Object[]{"PASSWORD_POLICY_USER_DATA"});
    }

    @Test
    public void shouldCheckPasswordNull() {
        User user = this.identityService.newUser("myUserId");
        String candidatePassword = null;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.checkPasswordAgainstPolicy(candidatePassword, user)).isInstanceOf(NullValueException.class)).hasMessageContaining("password is null");
    }

    @Test
    public void shouldCheckPasswordEmpty() {
        User user = this.identityService.newUser("myUserId");
        String candidatePassword = "";
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(candidatePassword, user);
        Assertions.assertThat((List)result.getFulfilledRules()).extracting("placeholder").contains(new Object[]{"PASSWORD_POLICY_USER_DATA"});
    }

    @Test
    public void shouldCheckUserNull() {
        User user = null;
        String candidatePassword = "my-password";
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(candidatePassword, user);
        Assertions.assertThat((List)result.getFulfilledRules()).extracting("placeholder").contains(new Object[]{"PASSWORD_POLICY_USER_DATA"});
    }

    private void checkThatPasswordWasInvalid(PasswordPolicyResult result) {
        MatcherAssert.assertThat((Object)result.getViolatedRules().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)result.getFulfilledRules().size(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)Is.is((Object)false));
    }
}

