/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.testing;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineTestCase;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.junit.Test;

public class ProcessEngineTestCaseTest
extends ProcessEngineTestCase {
    @Deployment
    @Test
    public void testSimpleProcess() {
        this.runtimeService.startProcessInstanceByKey("simpleProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessEngineTestCaseTest.assertEquals((String)"My Task", (String)task.getName());
        this.taskService.complete(task.getId());
        ProcessEngineTestCaseTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @RequiredHistoryLevel(value="audit")
    @Test
    public void testRequiredHistoryLevelAudit() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isIn(new Object[]{"audit", "full"});
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testRequiredHistoryLevelActivity() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isIn(new Object[]{"activity", "audit", "full"});
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testRequiredHistoryLevelFull() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isEqualTo((Object)"full");
    }

    protected String currentHistoryLevel() {
        return this.processEngine.getProcessEngineConfiguration().getHistory();
    }
}

