/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.QueryEntityRelationCondition;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryProperty;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.VariableOrderProperty;
import org.camunda.bpm.engine.impl.json.JsonTaskQueryConverter;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FilterTaskQueryTest
extends PluggableProcessEngineTest {
    protected Filter filter;
    protected String testString = "test";
    protected Integer testInteger = 1;
    protected DelegationState testDelegationState = DelegationState.PENDING;
    protected Date testDate = new Date(0L);
    protected String[] testActivityInstances = new String[]{"a", "b", "c"};
    protected String[] testKeys = new String[]{"d", "e"};
    protected List<String> testCandidateGroups = new ArrayList<String>();
    protected String[] testInstances = new String[]{"x", "y", "z"};
    protected String[] variableNames = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"};
    protected Object[] variableValues = new Object[]{1, 2, "3", "4", "5", 6, 7, "8", "9"};
    protected QueryOperator[] variableOperators = new QueryOperator[]{QueryOperator.EQUALS, QueryOperator.GREATER_THAN_OR_EQUAL, QueryOperator.LESS_THAN, QueryOperator.LIKE, QueryOperator.NOT_LIKE, QueryOperator.NOT_EQUALS, QueryOperator.LESS_THAN_OR_EQUAL, QueryOperator.LIKE, QueryOperator.NOT_LIKE};
    protected boolean[] isTaskVariable = new boolean[]{true, true, false, false, false, false, false, false, false};
    protected boolean[] isProcessVariable = new boolean[]{false, false, true, true, true, false, false, false, false};
    protected User testUser;
    protected Group testGroup;
    protected JsonTaskQueryConverter queryConverter;

    @Before
    public void setUp() {
        this.filter = this.filterService.newTaskFilter("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        this.testUser = this.identityService.newUser("user");
        this.testGroup = this.identityService.newGroup("group");
        this.identityService.saveUser(this.testUser);
        this.identityService.saveGroup(this.testGroup);
        this.identityService.createMembership(this.testUser.getId(), this.testGroup.getId());
        Group anotherGroup = this.identityService.newGroup("anotherGroup");
        this.identityService.saveGroup(anotherGroup);
        this.testCandidateGroups.add(this.testGroup.getId());
        this.testCandidateGroups.add(anotherGroup.getId());
        this.createTasks();
        this.queryConverter = new JsonTaskQueryConverter();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(false);
        Mocks.reset();
        for (Filter filter : this.filterService.createTaskFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            if (task.getProcessInstanceId() != null) continue;
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testEmptyQuery() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        String emptyQueryJson = "{}";
        this.filter.setQuery((Query)emptyQuery);
        Assert.assertEquals((Object)emptyQueryJson, (Object)((FilterEntity)this.filter).getQueryInternal());
        Assert.assertNotNull((Object)this.filter.getQuery());
    }

    @Test
    public void testTaskQuery() {
        int i;
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskId(this.testString);
        query.taskName(this.testString);
        query.taskNameNotEqual(this.testString);
        query.taskNameLike(this.testString);
        query.taskNameNotLike(this.testString);
        query.taskDescription(this.testString);
        query.taskDescriptionLike(this.testString);
        query.taskPriority(this.testInteger);
        query.taskMinPriority(this.testInteger);
        query.taskMaxPriority(this.testInteger);
        query.taskAssignee(this.testString);
        query.taskAssigneeExpression(this.testString);
        query.taskAssigneeLike(this.testString);
        query.taskAssigneeLikeExpression(this.testString);
        query.taskAssigneeIn(new String[]{this.testString});
        query.taskAssigneeNotIn(new String[]{this.testString});
        query.taskInvolvedUser(this.testString);
        query.taskInvolvedUserExpression(this.testString);
        query.taskOwner(this.testString);
        query.taskOwnerExpression(this.testString);
        query.taskUnassigned();
        query.taskAssigned();
        query.taskDelegationState(this.testDelegationState);
        query.taskCandidateGroupIn(this.testCandidateGroups);
        query.taskCandidateGroupInExpression(this.testString);
        query.withCandidateGroups();
        query.withoutCandidateGroups();
        query.withCandidateUsers();
        query.withoutCandidateUsers();
        query.processInstanceId(this.testString);
        query.processInstanceIdIn(this.testInstances);
        query.executionId(this.testString);
        query.activityInstanceIdIn(this.testActivityInstances);
        query.taskCreatedOn(this.testDate);
        query.taskCreatedOnExpression(this.testString);
        query.taskCreatedBefore(this.testDate);
        query.taskCreatedBeforeExpression(this.testString);
        query.taskCreatedAfter(this.testDate);
        query.taskCreatedAfterExpression(this.testString);
        query.taskUpdatedAfter(this.testDate);
        query.taskUpdatedAfterExpression(this.testString);
        query.taskDefinitionKey(this.testString);
        query.taskDefinitionKeyIn(this.testKeys);
        query.taskDefinitionKeyLike(this.testString);
        query.processDefinitionKey(this.testString);
        query.processDefinitionKeyIn(this.testKeys);
        query.processDefinitionId(this.testString);
        query.processDefinitionName(this.testString);
        query.processDefinitionNameLike(this.testString);
        query.processInstanceBusinessKey(this.testString);
        query.processInstanceBusinessKeyExpression(this.testString);
        query.processInstanceBusinessKeyIn(this.testKeys);
        query.processInstanceBusinessKeyLike(this.testString);
        query.processInstanceBusinessKeyLikeExpression(this.testString);
        query.taskVariableValueEquals(this.variableNames[0], this.variableValues[0]);
        query.taskVariableValueGreaterThanOrEquals(this.variableNames[1], this.variableValues[1]);
        query.processVariableValueLessThan(this.variableNames[2], this.variableValues[2]);
        query.processVariableValueLike(this.variableNames[3], (String)this.variableValues[3]);
        query.processVariableValueNotLike(this.variableNames[4], (String)this.variableValues[4]);
        query.caseInstanceVariableValueNotEquals(this.variableNames[5], this.variableValues[5]);
        query.caseInstanceVariableValueLessThanOrEquals(this.variableNames[6], this.variableValues[6]);
        query.caseInstanceVariableValueLike(this.variableNames[7], (String)this.variableValues[7]);
        query.caseInstanceVariableValueNotLike(this.variableNames[8], (String)this.variableValues[8]);
        query.dueDate(this.testDate);
        query.dueDateExpression(this.testString);
        query.dueBefore(this.testDate);
        query.dueBeforeExpression(this.testString);
        query.dueAfter(this.testDate);
        query.dueAfterExpression(this.testString);
        query.followUpDate(this.testDate);
        query.followUpDateExpression(this.testString);
        query.followUpBefore(this.testDate);
        query.followUpBeforeExpression(this.testString);
        query.followUpAfter(this.testDate);
        query.followUpAfterExpression(this.testString);
        query.excludeSubtasks();
        query.suspended();
        query.caseDefinitionKey(this.testString);
        query.caseDefinitionId(this.testString);
        query.caseDefinitionName(this.testString);
        query.caseDefinitionNameLike(this.testString);
        query.caseInstanceId(this.testString);
        query.caseInstanceBusinessKey(this.testString);
        query.caseInstanceBusinessKeyLike(this.testString);
        query.caseExecutionId(this.testString);
        query.orderByExecutionId().desc();
        query.orderByDueDate().asc();
        query.orderByProcessVariable("var", (ValueType)ValueType.STRING).desc();
        List expectedOrderingProperties = query.getOrderingProperties();
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertEquals((Object)this.testString, (Object)query.getTaskId());
        Assert.assertEquals((Object)this.testString, (Object)query.getName());
        Assert.assertEquals((Object)this.testString, (Object)query.getNameNotEqual());
        Assert.assertEquals((Object)this.testString, (Object)query.getNameNotLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getNameLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getDescription());
        Assert.assertEquals((Object)this.testString, (Object)query.getDescriptionLike());
        Assert.assertEquals((Object)this.testInteger, (Object)query.getPriority());
        Assert.assertEquals((Object)this.testInteger, (Object)query.getMinPriority());
        Assert.assertEquals((Object)this.testInteger, (Object)query.getMaxPriority());
        Assert.assertEquals((Object)this.testString, (Object)query.getAssignee());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskAssignee"));
        Assert.assertEquals((Object)this.testString, (Object)query.getAssigneeLike());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskAssigneeLike"));
        Assert.assertTrue((boolean)query.getAssigneeIn().contains(this.testString));
        Assert.assertTrue((boolean)query.getAssigneeNotIn().contains(this.testString));
        Assert.assertEquals((Object)this.testString, (Object)query.getInvolvedUser());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskInvolvedUser"));
        Assert.assertEquals((Object)this.testString, (Object)query.getOwner());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskOwner"));
        Assert.assertTrue((boolean)query.isUnassigned());
        Assert.assertTrue((boolean)query.isAssigned());
        Assert.assertEquals((Object)this.testDelegationState, (Object)query.getDelegationState());
        Assert.assertEquals(this.testCandidateGroups, (Object)query.getCandidateGroups());
        Assert.assertTrue((boolean)query.isWithCandidateGroups());
        Assert.assertTrue((boolean)query.isWithoutCandidateGroups());
        Assert.assertTrue((boolean)query.isWithCandidateUsers());
        Assert.assertTrue((boolean)query.isWithoutCandidateUsers());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCandidateGroupIn"));
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessInstanceId());
        Assert.assertEquals((long)this.testInstances.length, (long)query.getProcessInstanceIdIn().length);
        for (i = 0; i < query.getProcessInstanceIdIn().length; ++i) {
            Assert.assertEquals((Object)this.testInstances[i], (Object)query.getProcessInstanceIdIn()[i]);
        }
        Assert.assertEquals((Object)this.testString, (Object)query.getExecutionId());
        Assert.assertEquals((long)this.testActivityInstances.length, (long)query.getActivityInstanceIdIn().length);
        for (i = 0; i < query.getActivityInstanceIdIn().length; ++i) {
            Assert.assertEquals((Object)this.testActivityInstances[i], (Object)query.getActivityInstanceIdIn()[i]);
        }
        Assert.assertEquals((Object)this.testDate, (Object)query.getCreateTime());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCreatedOn"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getCreateTimeBefore());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCreatedBefore"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getCreateTimeAfter());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCreatedAfter"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getUpdatedAfter());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskUpdatedAfter"));
        Assert.assertEquals((Object)this.testString, (Object)query.getKey());
        Assert.assertEquals((long)this.testKeys.length, (long)query.getKeys().length);
        for (i = 0; i < query.getKeys().length; ++i) {
            Assert.assertEquals((Object)this.testKeys[i], (Object)query.getKeys()[i]);
        }
        Assert.assertEquals((Object)this.testString, (Object)query.getKeyLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessDefinitionKey());
        for (i = 0; i < query.getProcessDefinitionKeys().length; ++i) {
            Assert.assertEquals((Object)this.testKeys[i], (Object)query.getProcessDefinitionKeys()[i]);
        }
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessDefinitionId());
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessDefinitionName());
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessDefinitionNameLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessInstanceBusinessKey());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("processInstanceBusinessKey"));
        for (i = 0; i < query.getProcessInstanceBusinessKeys().length; ++i) {
            Assert.assertEquals((Object)this.testKeys[i], (Object)query.getProcessInstanceBusinessKeys()[i]);
        }
        Assert.assertEquals((Object)this.testString, (Object)query.getProcessInstanceBusinessKeyLike());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("processInstanceBusinessKeyLike"));
        List variables = query.getVariables();
        for (int i2 = 0; i2 < variables.size(); ++i2) {
            TaskQueryVariableValue variable = (TaskQueryVariableValue)variables.get(i2);
            Assert.assertEquals((Object)this.variableNames[i2], (Object)variable.getName());
            Assert.assertEquals((Object)this.variableValues[i2], (Object)variable.getValue());
            Assert.assertEquals((Object)this.variableOperators[i2], (Object)variable.getOperator());
            Assert.assertEquals((Object)this.isTaskVariable[i2], (Object)variable.isLocal());
            Assert.assertEquals((Object)this.isProcessVariable[i2], (Object)variable.isProcessInstanceVariable());
        }
        Assert.assertEquals((Object)this.testDate, (Object)query.getDueDate());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("dueDate"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getDueBefore());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("dueBefore"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getDueAfter());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("dueAfter"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getFollowUpDate());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("followUpDate"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getFollowUpBefore());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("followUpBefore"));
        Assert.assertEquals((Object)this.testDate, (Object)query.getFollowUpAfter());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("followUpAfter"));
        Assert.assertTrue((boolean)query.isExcludeSubtasks());
        Assert.assertEquals((Object)SuspensionState.SUSPENDED, (Object)query.getSuspensionState());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseDefinitionKey());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseDefinitionId());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseDefinitionName());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseDefinitionNameLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseInstanceId());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseInstanceBusinessKey());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseInstanceBusinessKeyLike());
        Assert.assertEquals((Object)this.testString, (Object)query.getCaseExecutionId());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
    }

    protected void verifyOrderingProperties(List<QueryOrderingProperty> expectedProperties, List<QueryOrderingProperty> actualProperties) {
        Assert.assertEquals((long)expectedProperties.size(), (long)actualProperties.size());
        for (int i = 0; i < expectedProperties.size(); ++i) {
            QueryOrderingProperty expectedProperty = expectedProperties.get(i);
            QueryOrderingProperty actualProperty = actualProperties.get(i);
            Assert.assertEquals((Object)expectedProperty.getRelation(), (Object)actualProperty.getRelation());
            Assert.assertEquals((Object)expectedProperty.getDirection(), (Object)actualProperty.getDirection());
            Assert.assertEquals((Object)expectedProperty.isContainedProperty(), (Object)actualProperty.isContainedProperty());
            Assert.assertEquals((Object)expectedProperty.getQueryProperty(), (Object)actualProperty.getQueryProperty());
            List expectedRelationConditions = expectedProperty.getRelationConditions();
            List actualRelationConditions = expectedProperty.getRelationConditions();
            if (expectedRelationConditions != null && actualRelationConditions != null) {
                Assert.assertEquals((long)expectedRelationConditions.size(), (long)actualRelationConditions.size());
                for (int j = 0; j < expectedRelationConditions.size(); ++j) {
                    QueryEntityRelationCondition expectedFilteringProperty = (QueryEntityRelationCondition)expectedRelationConditions.get(j);
                    QueryEntityRelationCondition actualFilteringProperty = (QueryEntityRelationCondition)expectedRelationConditions.get(j);
                    Assert.assertEquals((Object)expectedFilteringProperty.getProperty(), (Object)actualFilteringProperty.getProperty());
                    Assert.assertEquals((Object)expectedFilteringProperty.getComparisonProperty(), (Object)actualFilteringProperty.getComparisonProperty());
                    Assert.assertEquals((Object)expectedFilteringProperty.getScalarValue(), (Object)actualFilteringProperty.getScalarValue());
                }
                continue;
            }
            if ((expectedRelationConditions != null || actualRelationConditions == null) && (expectedRelationConditions == null || actualRelationConditions != null)) continue;
            Assert.fail((String)("Expected filtering properties: " + expectedRelationConditions + ". Actual filtering properties: " + actualRelationConditions));
        }
    }

    @Test
    public void testTaskQueryByBusinessKeyExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKey", (Object)aBusinessKey);
        this.createDeploymentWithBusinessKey(aBusinessKey);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(filter);
        TaskQueryImpl filterQuery = (TaskQueryImpl)this.filterService.getFilter(filter.getId()).getQuery();
        Assert.assertEquals(extendedQuery.getExpressions().get("processInstanceBusinessKey"), filterQuery.getExpressions().get("processInstanceBusinessKey"));
        Assert.assertEquals((long)1L, (long)this.filterService.list(filter.getId()).size());
    }

    @Test
    public void testTaskQueryByBusinessKeyExpressionInAdhocQuery() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(true);
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKey", (Object)aBusinessKey);
        this.createDeploymentWithBusinessKey(aBusinessKey);
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filterService.saveFilter(filter);
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Assert.assertEquals(extendingQuery.getExpressions().get("processInstanceBusinessKey"), (Object)("${ " + Mocks.getMocks().keySet().toArray()[0] + " }"));
        Assert.assertEquals((long)1L, (long)this.filterService.list(filter.getId(), (Query)extendingQuery).size());
    }

    @Test
    public void testTaskQueryByBusinessKeyLikeExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKeyLike", (Object)("%" + aBusinessKey.substring(5)));
        this.createDeploymentWithBusinessKey(aBusinessKey);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyLikeExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(filter);
        TaskQueryImpl filterQuery = (TaskQueryImpl)this.filterService.getFilter(filter.getId()).getQuery();
        Assert.assertEquals(extendedQuery.getExpressions().get("processInstanceBusinessKeyLike"), filterQuery.getExpressions().get("processInstanceBusinessKeyLike"));
        Assert.assertEquals((long)1L, (long)this.filterService.list(filter.getId()).size());
    }

    @Test
    public void testTaskQueryByBusinessKeyLikeExpressionInAdhocQuery() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(true);
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKeyLike", (Object)("%" + aBusinessKey.substring(5)));
        this.createDeploymentWithBusinessKey(aBusinessKey);
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filterService.saveFilter(filter);
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyLikeExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Assert.assertEquals(extendingQuery.getExpressions().get("processInstanceBusinessKeyLike"), (Object)("${ " + Mocks.getMocks().keySet().toArray()[0] + " }"));
        Assert.assertEquals((long)1L, (long)this.filterService.list(filter.getId(), (Query)extendingQuery).size());
    }

    protected void createDeploymentWithBusinessKey(String aBusinessKey) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", aBusinessKey);
    }

    @Test
    public void testTaskQueryByFollowUpBeforeOrNotExistent() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistent(this.testDate);
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertTrue((boolean)query.isFollowUpNullAccepted());
        Assert.assertEquals((Object)this.testDate, (Object)query.getFollowUpBefore());
    }

    @Test
    public void testTaskQueryByFollowUpBeforeOrNotExistentExtendingQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistent(this.testDate);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertEquals((long)3L, (long)tasks.size());
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)3L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void testTaskQueryByFollowUpBeforeOrNotExistentExpression() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistentExpression(this.testString);
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertTrue((boolean)query.isFollowUpNullAccepted());
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("followUpBeforeOrNotExistent"));
    }

    @Test
    public void testTaskQueryByFollowUpBeforeOrNotExistentExpressionExtendingQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistentExpression("${dateTime().withMillis(0)}");
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertEquals((long)3L, (long)tasks.size());
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)3L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
    }

    @Test
    public void testTaskQueryCandidateUser() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(this.testUser.getId());
        query.taskCandidateUserExpression(this.testUser.getId());
        this.filter.setQuery((Query)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertEquals((Object)this.testUser.getId(), (Object)query.getCandidateUser());
        Assert.assertEquals((Object)this.testUser.getId(), query.getExpressions().get("taskCandidateUser"));
    }

    @Test
    public void testTaskQueryCandidateGroup() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroup(this.testGroup.getId());
        query.taskCandidateGroupExpression(this.testGroup.getId());
        this.filter.setQuery((Query)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertEquals((Object)this.testGroup.getId(), (Object)query.getCandidateGroup());
        Assert.assertEquals((Object)this.testGroup.getId(), query.getExpressions().get("taskCandidateGroup"));
    }

    @Test
    public void testTaskQueryCandidateUserIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(this.testUser.getId());
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals((Object)this.testUser.getId(), (Object)query.getCandidateUser());
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testTaskQueryCandidateUserExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUserExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCandidateUser"));
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testTaskQueryCandidateGroupIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroup(this.testGroup.getId());
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals((Object)this.testGroup.getId(), (Object)query.getCandidateGroup());
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testTaskQueryCandidateGroupExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCandidateGroup"));
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testTaskQueryCandidateGroupsIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupIn(this.testCandidateGroups);
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals(this.testCandidateGroups, (Object)query.getCandidateGroupsInternal());
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testTaskQueryCandidateGroupsExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupInExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        Assert.assertEquals((Object)this.testString, query.getExpressions().get("taskCandidateGroupIn"));
        Assert.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    @Test
    public void testExecuteTaskQueryList() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("Task%");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            Assert.assertEquals((Object)this.testUser.getId(), (Object)task.getOwner());
        }
    }

    @Test
    public void testExtendingTaskQueryList() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)3L, (long)tasks.size());
        tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertEquals((long)3L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskDelegationState(DelegationState.RESOLVED);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        }
    }

    @Test
    public void testExtendingTaskQueryWithAssigneeIn() {
        Task task = this.taskService.newTask("assigneeTask");
        task.setName("Task 4");
        task.setOwner(this.testUser.getId());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "john");
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeIn(new String[]{"john"});
        this.saveQuery(query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskAssigneeIn(new String[]{"john", "kermit"});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)1L, (long)origQueryTasks.size());
        Assert.assertEquals((long)1L, (long)selfExtendQueryTasks.size());
        Assert.assertEquals((long)2L, (long)extendingQueryTasks.size());
    }

    @Test
    public void testExtendingTaskQueryWithAssigneeNotIn() {
        Task task = this.taskService.newTask("assigneeTask");
        task.setName("Task 5");
        task.setOwner(this.testUser.getId());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "john");
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeNotIn(new String[]{"kermit"});
        this.saveQuery(query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskAssigneeNotIn(new String[]{"john", "kermit"});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)1L, (long)origQueryTasks.size());
        Assert.assertEquals((long)1L, (long)selfExtendQueryTasks.size());
        Assert.assertEquals((long)0L, (long)extendingQueryTasks.size());
    }

    @Test
    public void testExtendingTaskQueryListWithCandidateGroups() {
        TaskQuery query = this.taskService.createTaskQuery();
        ArrayList<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add("accounting");
        query.taskCandidateGroupIn(candidateGroups);
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testExtendingTaskQueryListWithIncludeAssignedTasks() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroup("accounting");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskCandidateGroup("accounting").includeAssignedTasks();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testExtendTaskQueryWithCandidateUserExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateUserExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateUser"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateUser"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    @Test
    public void testExtendTaskQueryWithCandidateGroupExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroupExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateGroup"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateGroup"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    @Test
    public void testExtendTaskQueryWithCandidateGroupInAndCandidateGroup() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList("testGroup", "testGroup2"));
        Assert.assertEquals((long)2L, (long)candidateGroupInQuery.getCandidateGroups().size());
        Assert.assertEquals((Object)"testGroup", candidateGroupInQuery.getCandidateGroups().get(0));
        Assert.assertEquals((Object)"testGroup2", candidateGroupInQuery.getCandidateGroups().get(1));
        Filter candidateGroupInFilter = this.filterService.newTaskFilter("Groups filter");
        candidateGroupInFilter.setQuery((Query)candidateGroupInQuery);
        TaskQuery candidateGroupQuery = this.taskService.createTaskQuery().taskCandidateGroup("testGroup2");
        Filter extendedFilter = candidateGroupInFilter.extend((Query)candidateGroupQuery);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((long)1L, (long)extendedQuery.getCandidateGroups().size());
        Assert.assertEquals((Object)"testGroup2", extendedQuery.getCandidateGroups().get(0));
    }

    @Test
    public void testTaskQueryWithCandidateGroupInExpressionAndCandidateGroup() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupInExpression("${'test'}").taskCandidateGroup("testGroup");
        Assert.assertEquals((Object)"${'test'}", candidateGroupInQuery.getExpressions().get("taskCandidateGroupIn"));
        Assert.assertEquals((Object)"testGroup", (Object)candidateGroupInQuery.getCandidateGroup());
    }

    @Test
    public void testTaskQueryWithCandidateGroupInAndCandidateGroupExpression() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList("testGroup", "testGroup2")).taskCandidateGroupExpression("${'test'}");
        Assert.assertEquals((Object)"${'test'}", candidateGroupInQuery.getExpressions().get("taskCandidateGroup"));
        Assert.assertEquals((long)2L, (long)candidateGroupInQuery.getCandidateGroups().size());
        Assert.assertEquals((Object)"testGroup", candidateGroupInQuery.getCandidateGroups().get(0));
        Assert.assertEquals((Object)"testGroup2", candidateGroupInQuery.getCandidateGroups().get(1));
    }

    @Test
    public void testExtendTaskQueryWithCandidateGroupInExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroupInExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateGroupIn"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        Assert.assertEquals((Object)"${'test'}", extendedQuery.getExpressions().get("taskCandidateGroupIn"));
        Assert.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    @Test
    public void testExecuteTaskQueryListPage() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("Task%");
        this.saveQuery(query);
        List tasks = this.filterService.listPage(this.filter.getId(), 1, 2);
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            Assert.assertEquals((Object)this.testUser.getId(), (Object)task.getOwner());
        }
    }

    @Test
    public void testExtendingTaskQueryListPage() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        List tasks = this.filterService.listPage(this.filter.getId(), 1, 2);
        Assert.assertEquals((long)2L, (long)tasks.size());
        tasks = this.filterService.listPage(this.filter.getId(), (Query)query, 1, 2);
        Assert.assertEquals((long)2L, (long)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskDelegationState(DelegationState.RESOLVED);
        tasks = this.filterService.listPage(this.filter.getId(), (Query)extendingQuery, 1, 2);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)((Task)tasks.get(0)).getDelegationState());
    }

    @Test
    public void testExecuteTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskDelegationState(DelegationState.PENDING);
        this.saveQuery(query);
        Task task = (Task)this.filterService.singleResult(this.filter.getId());
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task 1", (Object)task.getName());
    }

    @Test
    public void testFailTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        try {
            this.filterService.singleResult(this.filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testExtendingTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskDelegationState(DelegationState.PENDING);
        this.saveQuery(query);
        Task task = (Task)this.filterService.singleResult(this.filter.getId());
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task 1", (Object)task.getName());
        Assert.assertEquals((Object)"task1", (Object)task.getId());
        task = (Task)this.filterService.singleResult(this.filter.getId(), (Query)query);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task 1", (Object)task.getName());
        Assert.assertEquals((Object)"task1", (Object)task.getId());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskId("task1");
        task = (Task)this.filterService.singleResult(this.filter.getId(), (Query)extendingQuery);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task 1", (Object)task.getName());
        Assert.assertEquals((Object)"task1", (Object)task.getId());
    }

    @Test
    public void testTaskQueryLookupByNameCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskName("task 1");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(1);
        query = this.taskService.createTaskQuery();
        query.taskName("tASk 2");
        this.saveQuery(query);
        tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test
    public void testTaskQueryLookupByDescriptionCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskDescription("description 1");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(1);
        query = this.taskService.createTaskQuery();
        query.taskDescription("dEscription 2");
        this.saveQuery(query);
        tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Test
    public void testTaskQueryLookupByNameLikeCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("%task%");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(3);
        query = this.taskService.createTaskQuery();
        query.taskNameLike("%Task%");
        this.saveQuery(query);
        tasks = this.filterService.list(this.filter.getId());
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((List)tasks).hasSize(3);
    }

    @Test
    public void testExecuteTaskQueryCount() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        long count = this.filterService.count(this.filter.getId());
        Assert.assertEquals((long)3L, (long)count);
        query.taskDelegationState(DelegationState.RESOLVED);
        this.saveQuery(query);
        count = this.filterService.count(this.filter.getId());
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testExtendingTaskQueryCount() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskId("task3");
        long count = this.filterService.count(this.filter.getId());
        Assert.assertEquals((long)3L, (long)count);
        count = this.filterService.count(this.filter.getId(), (Query)query);
        Assert.assertEquals((long)3L, (long)count);
        count = this.filterService.count(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testSpecialExtendingQuery() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        long count = this.filterService.count(this.filter.getId(), (Query)null);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testExtendingSorting() {
        TaskQueryImpl query = (TaskQueryImpl)this.taskService.createTaskQuery();
        this.saveQuery((TaskQuery)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertTrue((boolean)query.getOrderingProperties().isEmpty());
        TaskQueryImpl sortQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByTaskName().asc();
        Filter extendedFilter = this.filter.extend((Query)sortQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        ArrayList<QueryOrderingProperty> expectedOrderingProperties = new ArrayList<QueryOrderingProperty>(sortQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByTaskAssignee().desc();
        extendedFilter = extendedFilter.extend((Query)extendingQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        expectedOrderingProperties.addAll(extendingQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
        sortQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByCaseExecutionId();
        extendedFilter = extendedFilter.extend((Query)sortQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        expectedOrderingProperties.addAll(sortQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
    }

    @Test
    public void testDeprecatedOrderingFormatDeserializationSingleOrdering() {
        String sortByNameAsc = "RES." + TaskQueryProperty.NAME.getName() + " " + Direction.ASCENDING.getName();
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", sortByNameAsc);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        Assert.assertEquals((long)1L, (long)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        Assert.assertNull((Object)orderingProperty.getRelation());
        Assert.assertEquals((Object)"asc", (Object)orderingProperty.getDirection().getName());
        Assert.assertNull((Object)orderingProperty.getRelationConditions());
        Assert.assertTrue((boolean)orderingProperty.isContainedProperty());
        Assert.assertEquals((Object)TaskQueryProperty.NAME.getName(), (Object)orderingProperty.getQueryProperty().getName());
        Assert.assertNull((Object)orderingProperty.getQueryProperty().getFunction());
    }

    @Test
    public void testDeprecatedOrderingFormatDeserializationSecondaryOrdering() {
        String sortByNameAsc = "RES." + TaskQueryProperty.NAME.getName() + " " + Direction.ASCENDING.getName();
        String secondaryOrdering = sortByNameAsc + ", RES." + TaskQueryProperty.ASSIGNEE.getName() + " " + Direction.DESCENDING.getName();
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", secondaryOrdering);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        Assert.assertEquals((long)2L, (long)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty1 = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        Assert.assertNull((Object)orderingProperty1.getRelation());
        Assert.assertEquals((Object)"asc", (Object)orderingProperty1.getDirection().getName());
        Assert.assertNull((Object)orderingProperty1.getRelationConditions());
        Assert.assertTrue((boolean)orderingProperty1.isContainedProperty());
        Assert.assertEquals((Object)TaskQueryProperty.NAME.getName(), (Object)orderingProperty1.getQueryProperty().getName());
        Assert.assertNull((Object)orderingProperty1.getQueryProperty().getFunction());
        QueryOrderingProperty orderingProperty2 = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(1);
        Assert.assertNull((Object)orderingProperty2.getRelation());
        Assert.assertEquals((Object)"desc", (Object)orderingProperty2.getDirection().getName());
        Assert.assertNull((Object)orderingProperty2.getRelationConditions());
        Assert.assertTrue((boolean)orderingProperty2.isContainedProperty());
        Assert.assertEquals((Object)TaskQueryProperty.ASSIGNEE.getName(), (Object)orderingProperty2.getQueryProperty().getName());
        Assert.assertNull((Object)orderingProperty2.getQueryProperty().getFunction());
    }

    @Test
    public void testDeprecatedOrderingFormatDeserializationFunctionOrdering() {
        String orderingWithFunction = "LOWER(RES." + TaskQueryProperty.NAME.getName() + ") asc";
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", orderingWithFunction);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        Assert.assertEquals((long)1L, (long)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        Assert.assertNull((Object)orderingProperty.getRelation());
        Assert.assertEquals((Object)"asc", (Object)orderingProperty.getDirection().getName());
        Assert.assertNull((Object)orderingProperty.getRelationConditions());
        Assert.assertFalse((boolean)orderingProperty.isContainedProperty());
        Assert.assertEquals((Object)TaskQueryProperty.NAME_CASE_INSENSITIVE.getName(), (Object)orderingProperty.getQueryProperty().getName());
        Assert.assertEquals((Object)TaskQueryProperty.NAME_CASE_INSENSITIVE.getFunction(), (Object)orderingProperty.getQueryProperty().getFunction());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/oneTaskWithFormKeyProcess.bpmn20.xml"})
    @Test
    public void testInitializeFormKeysEnabled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        this.saveQuery(query);
        Task task = (Task)this.filterService.list(this.filter.getId()).get(0);
        Assert.assertEquals((Object)"exampleFormKey", (Object)task.getFormKey());
        task = (Task)this.filterService.singleResult(this.filter.getId());
        Assert.assertEquals((Object)"exampleFormKey", (Object)task.getFormKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    @Test
    public void testExtendingVariableQuery() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().processVariableValueEquals("hello", (Object)"world");
        this.saveQuery(taskQuery);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskVariableValueEquals("hello", (Object)"world").caseInstanceVariableValueEquals("hello", (Object)"world");
        Filter extendedFilter = this.filter.extend((Query)extendingQuery);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        List variables = extendedQuery.getVariables();
        Assert.assertEquals((long)3L, (long)variables.size());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(0)).getName());
        Assert.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(0)).getValue());
        Assert.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(0)).getOperator());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(0)).isProcessInstanceVariable());
        Assert.assertTrue((boolean)((TaskQueryVariableValue)variables.get(0)).isLocal());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(1)).getName());
        Assert.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(1)).getValue());
        Assert.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(1)).getOperator());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isProcessInstanceVariable());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isLocal());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(2)).getName());
        Assert.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(2)).getValue());
        Assert.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(2)).getOperator());
        Assert.assertTrue((boolean)((TaskQueryVariableValue)variables.get(2)).isProcessInstanceVariable());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isLocal());
        extendingQuery = this.taskService.createTaskQuery().processVariableValueLessThan("hello", (Object)42).taskVariableValueLessThan("hello", (Object)42).caseInstanceVariableValueLessThan("hello", (Object)42);
        extendedFilter = this.filter.extend((Query)extendingQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        variables = extendedQuery.getVariables();
        Assert.assertEquals((long)3L, (long)variables.size());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(0)).getName());
        Assert.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(0)).getValue());
        Assert.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(0)).getOperator());
        Assert.assertTrue((boolean)((TaskQueryVariableValue)variables.get(0)).isProcessInstanceVariable());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(0)).isLocal());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(1)).getName());
        Assert.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(1)).getValue());
        Assert.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(1)).getOperator());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isProcessInstanceVariable());
        Assert.assertTrue((boolean)((TaskQueryVariableValue)variables.get(1)).isLocal());
        Assert.assertEquals((Object)"hello", (Object)((TaskQueryVariableValue)variables.get(2)).getName());
        Assert.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(2)).getValue());
        Assert.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(2)).getOperator());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isProcessInstanceVariable());
        Assert.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isLocal());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendTaskQueryByOrderByProcessVariable() {
        ProcessInstance instance500 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)500));
        ProcessInstance instance1000 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)1000));
        ProcessInstance instance250 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)250));
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery(query);
        TaskQuery extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc();
        List tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance250.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance500.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1000.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance1000.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance500.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance250.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        this.runtimeService.deleteProcessInstance(instance250.getId(), null);
        this.runtimeService.deleteProcessInstance(instance500.getId(), null);
        this.runtimeService.deleteProcessInstance(instance1000.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendTaskQueryByOrderByTaskVariable() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task500 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task500.getId(), "var", (Object)500);
        Task task250 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task250.getId(), "var", (Object)250);
        Task task1000 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1000.getId(), "var", (Object)1000);
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery(query);
        TaskQuery extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc();
        List tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)task250.getId(), (Object)((Task)tasks.get(0)).getId());
        Assert.assertEquals((Object)task500.getId(), (Object)((Task)tasks.get(1)).getId());
        Assert.assertEquals((Object)task1000.getId(), (Object)((Task)tasks.get(2)).getId());
        extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)task1000.getId(), (Object)((Task)tasks.get(0)).getId());
        Assert.assertEquals((Object)task500.getId(), (Object)((Task)tasks.get(1)).getId());
        Assert.assertEquals((Object)task250.getId(), (Object)((Task)tasks.get(2)).getId());
        this.runtimeService.deleteProcessInstance(instance1.getId(), null);
        this.runtimeService.deleteProcessInstance(instance2.getId(), null);
        this.runtimeService.deleteProcessInstance(instance3.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendTaskQueryByTaskVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(taskCamelCase.getId(), variableName, (Object)variableValueCamelCase);
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(taskLowerCase.getId(), variableName, (Object)variableValueLowerCase);
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().taskVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().taskVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase.toLowerCase());
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExtendTaskQueryByCaseInstanceVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        HashMap<String, String> variables = new HashMap<String, String>();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        variables.put(variableName, variableValueCamelCase);
        CaseInstance instanceCamelCase = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        variables.put(variableName, variableValueLowerCase);
        CaseInstance instanceLowerCase = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        CaseInstance instanceWithoutVariables = this.caseService.createCaseInstanceById(caseDefinitionId);
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceCamelCase.getId()).singleResult();
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceLowerCase.getId()).singleResult();
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceWithoutVariables.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().caseDefinitionId(caseDefinitionId);
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueNotLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        this.caseService.terminateCaseExecution(instanceCamelCase.getId());
        this.caseService.terminateCaseExecution(instanceLowerCase.getId());
        this.caseService.terminateCaseExecution(instanceWithoutVariables.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendTaskQueryByProcessVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValueCamelCase);
        ProcessInstance instanceCamelCase = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        variables.put(variableName, variableValueLowerCase);
        ProcessInstance instanceLowerCase = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstance instanceWithoutVariables = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().processInstanceId(instanceCamelCase.getId()).singleResult();
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().processInstanceId(instanceLowerCase.getId()).singleResult();
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().processInstanceId(instanceWithoutVariables.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery(query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().processVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().processVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().processVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().processVariableValueNotLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertFalse((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertFalse((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertTrue((boolean)tasks.contains(taskCamelCase));
        Assert.assertTrue((boolean)tasks.contains(taskLowerCase));
        Assert.assertFalse((boolean)tasks.contains(taskWithNoVariable));
    }

    @Test
    public void testExtendTaskQuery_ORInExtendingQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().taskName("taskForOr");
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().taskDescription("aTaskDescription").taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        Assert.assertEquals((long)4L, (long)extendedQuery.list().size());
        Assert.assertEquals((long)4L, (long)this.filterService.list(extendedFilter.getId()).size());
        Assert.assertEquals((long)6L, (long)extendingQuery.list().size());
        Assert.assertEquals((long)3L, (long)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    @Test
    public void testExtendTaskQuery_ORInExtendedQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskDescription("aTaskDescription").taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("taskForOr");
        Assert.assertEquals((long)6L, (long)extendedQuery.list().size());
        Assert.assertEquals((long)6L, (long)this.filterService.list(extendedFilter.getId()).size());
        Assert.assertEquals((long)4L, (long)extendingQuery.list().size());
        Assert.assertEquals((long)3L, (long)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    @Test
    public void testExtendTaskQuery_ORInBothExtendedAndExtendingQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskName("taskForOr").taskDescription("aTaskDescription").endOr();
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().tenantIdIn(new String[]{"aTenantId"}).taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        Assert.assertEquals((long)6L, (long)extendedQuery.list().size());
        Assert.assertEquals((long)6L, (long)this.filterService.list(extendedFilter.getId()).size());
        Assert.assertEquals((long)4L, (long)extendingQuery.list().size());
        Assert.assertEquals((long)3L, (long)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    @Test
    public void testOrderByVariables() {
        TaskQueryImpl query = (TaskQueryImpl)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("foo", (ValueType)ValueType.STRING).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseInstanceVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByTaskVariable("foo", (ValueType)ValueType.STRING).asc();
        Filter filter = this.filterService.newTaskFilter("extendedOrFilter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        filter = this.filterService.getFilter(filter.getId());
        ArrayList<QueryOrderingProperty> expectedOrderingProperties = new ArrayList<QueryOrderingProperty>(query.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, ((TaskQueryImpl)filter.getQuery()).getOrderingProperties());
        for (QueryOrderingProperty prop : ((TaskQueryImpl)filter.getQuery()).getOrderingProperties()) {
            Assert.assertTrue((boolean)(prop instanceof VariableOrderProperty));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testBooleanVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("booleanVariable", (Object)true));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("booleanVariable", (Object)true);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testIntVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("intVariable", (Object)7));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("intVariable", (Object)7);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testIntOutOfRangeVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("longVariable", (Object)0x80000000L));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("longVariable", (Object)0x80000000L);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDoubleVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("doubleVariable", (Object)88.89));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("doubleVariable", (Object)88.89);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStringVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("stringVariable", (Object)"aVariableValue"));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("stringVariable", (Object)"aVariableValue");
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testNullVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("nullVariable", null));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("nullVariable", null);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDueDate() {
        Date date = new Date();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        task.setDueDate(date);
        this.taskService.saveTask(task);
        TaskQuery query = this.taskService.createTaskQuery().dueDate(date);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Test
    public void testWithoutDueDate() {
        Task task = this.taskService.newTask();
        task.setDueDate(new Date());
        this.taskService.saveTask(task);
        TaskQuery query = this.taskService.createTaskQuery().withoutDueDate();
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        Assertions.assertThat((Long)this.filterService.count(this.filter.getId())).isEqualTo(3L);
    }

    @Test
    public void testExtendQueryByWithoutDueDate() {
        Task task = this.taskService.newTask();
        task.setDueDate(new Date());
        this.taskService.saveTask(task);
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery(query);
        Assertions.assertThat((Long)this.filterService.count(this.filter.getId())).isEqualTo(4L);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().withoutDueDate();
        Assertions.assertThat((Long)this.filterService.count(this.filter.getId(), (Query)extendingQuery)).isEqualTo(3L);
    }

    @Test
    public void testTaskIdInPositive() {
        List existingTasks = this.taskService.createTaskQuery().list();
        String task1 = ((Task)existingTasks.get(0)).getId();
        String task2 = ((Task)existingTasks.get(1)).getId();
        TaskQueryImpl query = (TaskQueryImpl)this.taskService.createTaskQuery().taskIdIn(new String[]{task1, task2});
        Filter filter = this.filterService.newTaskFilter("taskIDfilter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)filter.getQuery();
        Assertions.assertThat((Object[])query.getTaskIdIn()).containsOnly((Object[])new String[]{task1, task2});
    }

    @Test
    public void testAssigneeInPositive() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        taskQuery.taskAssigneeIn(new String[]{this.testString});
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertTrue((boolean)taskQuery.getAssigneeIn().contains(this.testString));
    }

    @Test
    public void testAssigneeNotInPositive() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        taskQuery.taskAssigneeNotIn(new String[]{this.testString});
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertTrue((boolean)taskQuery.getAssigneeNotIn().contains(this.testString));
    }

    @Test
    public void testAssigneeInNegative() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertNull((Object)taskQuery.getAssigneeIn());
    }

    @Test
    public void testAssigneeNotInNegative() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        Assert.assertNull((Object)taskQuery.getAssigneeNotIn());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-9613")
    @Test
    public void testDateVariable() {
        Date date = new Date();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("dateVariable", (Object)date));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("dateVariable", (Object)date);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-9613")
    @Test
    public void testByteArrayVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("bytesVariable", (Object)"aByteArray".getBytes()));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("bytesVariable", (Object)"aByteArray".getBytes());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-9613")
    @Test
    public void testLongVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("longVariable", (Object)7L));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("longVariable", (Object)7L);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Ignore(value="CAM-9613")
    @Test
    public void testShortVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("shortVariable", (Object)7));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("shortVariable", (Object)7);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assertions.assertThat((Long)this.filterService.count(filter.getId())).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendingTaskQueryWithProcessInstanceIn() {
        String firstId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String secondId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        TaskQuery query = this.taskService.createTaskQuery().processInstanceIdIn(new String[]{firstId});
        this.saveQuery(query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.processInstanceIdIn(new String[]{firstId, secondId});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        Assert.assertEquals((long)1L, (long)origQueryTasks.size());
        Assert.assertEquals((long)1L, (long)selfExtendQueryTasks.size());
        Assert.assertEquals((long)2L, (long)extendingQueryTasks.size());
    }

    @Test
    public void shouldDeserializeOrQueryWithCandidateGroupAndUser() {
        TaskQuery query = this.taskService.createTaskQuery().or().taskCandidateGroup("foo").taskCandidateUser("bar").endOr();
        JsonObject jsonObject = this.queryConverter.toJsonObject(query);
        this.queryConverter.toObject(jsonObject);
    }

    protected void saveQuery(TaskQuery query) {
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
    }

    protected void createTasks() {
        Task task = this.taskService.newTask("task1");
        task.setName("Task 1");
        task.setDescription("Description 1");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        this.taskService.addCandidateGroup(task.getId(), "accounting");
        task = this.taskService.newTask("task2");
        task.setName("Task 2");
        task.setDescription("Description 2");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "kermit");
        this.taskService.addCandidateGroup(task.getId(), "accounting");
        task = this.taskService.newTask("task3");
        task.setName("Task 3");
        task.setDescription("Description 3");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
    }

    protected void createTasksForOrQueries() {
        Task task1 = this.taskService.newTask();
        task1.setName("taskForOr");
        task1.setDescription("aTaskDescription");
        task1.setPriority(3);
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("taskForOr");
        task2.setDescription("aTaskDescription");
        task2.setAssignee("aTaskAssignee");
        task2.setTenantId("aTenantId");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("taskForOr");
        task3.setOwner("aTaskOwner");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("taskForOr");
        task4.setOwner("aTaskOwner");
        task4.setPriority(3);
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setDescription("aTaskDescription");
        task5.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task5);
        Task task6 = this.taskService.newTask();
        task6.setDescription("aTaskDescription");
        task6.setAssignee("aTaskAssignee");
        task6.setTenantId("aTenantId");
        this.taskService.saveTask(task6);
        Task task7 = this.taskService.newTask();
        task7.setTenantId("aTenantId");
        task7.setOwner("aTaskOwner");
        task7.setPriority(3);
        task7.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task7);
    }
}

