/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.spi.DmnEngineMetricCollector;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecisionMetricsTest
extends AbstractMetricsTest {
    public static final String DECISION_DEFINITION_KEY = "decision";
    public static final String DRD_DISH_DECISION_TABLE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    public static final String DMN_DECISION_LITERAL_EXPRESSION = "org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn";
    public static final String DMN_FILE = "org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml";
    public static VariableMap VARIABLES = Variables.createVariables().putValue("status", (Object)"").putValue("sum", (Object)100);
    protected DecisionService decisionService;

    @Before
    public void setUp() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        this.decisionService = this.engineRule.getDecisionService();
    }

    @After
    public void restore() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Override
    protected void clearMetrics() {
        super.clearMetrics();
        DmnEngineMetricCollector metricCollector = this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector();
        metricCollector.clearExecutedDecisionInstances();
        metricCollector.clearExecutedDecisionElements();
    }

    @Test
    public void testBusinessRuleTask() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"testProcess").startEvent().businessRuleTask("task").endEvent().done();
        BusinessRuleTask task = (BusinessRuleTask)modelInstance.getModelElementById("task");
        task.setCamundaDecisionRef(DECISION_DEFINITION_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).addClasspathResource(DMN_FILE));
        Assert.assertEquals((long)0L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)0L, (long)this.getDecisionInstances());
        Assert.assertEquals((long)0L, (long)this.getExecutedDecisionElements());
        Assert.assertEquals((long)0L, (long)this.getExecutedDecisionInstancesFromDmnEngine());
        Assert.assertEquals((long)0L, (long)this.getExecutedDecisionElementsFromDmnEngine());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)VARIABLES);
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)1L, (long)this.getDecisionInstances());
        Assert.assertEquals((long)16L, (long)this.getExecutedDecisionElements());
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstancesFromDmnEngine());
        Assert.assertEquals((long)16L, (long)this.getExecutedDecisionElementsFromDmnEngine());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)1L, (long)this.getDecisionInstances());
        Assert.assertEquals((long)16L, (long)this.getExecutedDecisionElements());
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstancesFromDmnEngine());
        Assert.assertEquals((long)16L, (long)this.getExecutedDecisionElementsFromDmnEngine());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    public void shouldCountDecisionLiteralExpression() {
        this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)VARIABLES).evaluate();
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)1L, (long)this.getDecisionInstances());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)1L, (long)this.getDecisionInstances());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCountDecisionDRG() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)VARIABLES.putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        Assert.assertEquals((long)3L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)3L, (long)this.getDecisionInstances());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)3L, (long)this.getExecutedDecisionInstances());
        Assert.assertEquals((long)3L, (long)this.getDecisionInstances());
    }

    protected long getExecutedDecisionInstances() {
        return this.managementService.createMetricsQuery().name("executed-decision-instances").sum();
    }

    protected long getDecisionInstances() {
        return this.managementService.createMetricsQuery().name("decision-instances").sum();
    }

    protected long getExecutedDecisionElements() {
        return this.managementService.createMetricsQuery().name("executed-decision-elements").sum();
    }

    protected long getExecutedDecisionInstancesFromDmnEngine() {
        return this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector().getExecutedDecisionInstances();
    }

    protected long getExecutedDecisionElementsFromDmnEngine() {
        return this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector().getExecutedDecisionElements();
    }
}

