/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyStartProcessInstanceByConditionCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance PROCESS = ((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"conditionStart").startEvent().conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    public IdentityService identityService;
    public RepositoryService repositoryService;
    public RuntimeService runtimeService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void testNoAuthenticatedTenants() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.ensureEventSubscriptions(3);
        this.identityService.setAuthentication("user", null, null);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List instances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.identityService.clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.withoutTenantId().count());
    }

    @Test
    public void testWithAuthenticatedTenant() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.ensureEventSubscriptions(2);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List processInstances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).tenantId(TENANT_ONE).evaluateStartConditions();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        this.identityService.clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_ONE}).count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_TWO}).count());
    }

    @Test
    public void testWithAuthenticatedTenant2() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.ensureEventSubscriptions(2);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List processInstances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        this.identityService.clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_ONE}).count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_TWO}).count());
    }

    @Test
    public void testDisabledTenantCheck() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.ensureEventSubscriptions(2);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("foo", "bar");
        List evaluateStartConditions = this.engineRule.getRuntimeService().createConditionEvaluation().setVariables(variableMap).evaluateStartConditions();
        Assert.assertEquals((long)2L, (long)evaluateStartConditions.size());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testFailToEvaluateConditionByProcessDefinitionIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.ensureEventSubscriptions(1);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("conditionStart").singleResult();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createConditionEvaluation().setVariable("foo", (Object)"bar").processDefinitionId(processDefinition.getId()).evaluateStartConditions()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot create an instance of the process definition");
    }

    @Test
    public void testEvaluateConditionByProcessDefinitionIdWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.ensureEventSubscriptions(1);
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("conditionStart").singleResult();
        this.identityService = this.engineRule.getIdentityService();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List instances = this.engineRule.getRuntimeService().createConditionEvaluation().setVariable("foo", (Object)"bar").tenantId(TENANT_ONE).processDefinitionId(processDefinition.getId()).evaluateStartConditions();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((ProcessInstance)instances.get(0)).getTenantId());
        this.identityService.clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)processInstanceQuery.tenantIdIn(new String[]{TENANT_ONE}).count());
        EventSubscription eventSubscription = (EventSubscription)this.engineRule.getRuntimeService().createEventSubscriptionQuery().singleResult();
        Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)eventSubscription.getEventType());
    }

    @Test
    public void testSubscriptionsWhenDeletingGroupsProcessDefinitionsByIds() {
        String processDefId1 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, PROCESS).getId();
        String processDefId2 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, PROCESS).getId();
        String processDefId3 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, PROCESS).getId();
        String processDefId4 = this.testRule.deployAndGetDefinition(PROCESS).getId();
        String processDefId5 = this.testRule.deployAndGetDefinition(PROCESS).getId();
        String processDefId6 = this.testRule.deployAndGetDefinition(PROCESS).getId();
        BpmnModelInstance processAnotherKey = ((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"anotherKey").startEvent().conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask().endEvent().done();
        String processDefId7 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId8 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId9 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        Assert.assertEquals((long)3L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{processDefId8, processDefId5, processDefId3, processDefId9, processDefId1}).delete();
        List list = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (EventSubscription eventSubscription : list) {
            EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)eventSubscription;
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId2)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId6)) {
                Assert.assertEquals(null, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId7)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            Assert.fail((String)("This process definition '" + eventSubscriptionEntity.getConfiguration() + "' and the respective event subscription should not exist."));
        }
    }

    protected void ensureEventSubscriptions(int count) {
        List eventSubscriptions = this.engineRule.getRuntimeService().createEventSubscriptionQuery().list();
        Assert.assertEquals((long)count, (long)eventSubscriptions.size());
        for (EventSubscription eventSubscription : eventSubscriptions) {
            Assert.assertEquals((Object)EventType.CONDITONAL.name(), (Object)eventSubscription.getEventType());
        }
    }
}

