/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.logging;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.logging.LogEngineNameDelegate;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessDataLoggingContextMultipleEnginesTest {
    private static final String PVM_LOGGER = "org.camunda.bpm.engine.pvm";
    private static final String DELEGATE_LOGGER = LogEngineNameDelegate.class.getName();
    private static final String PROCESS = "process";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.pvm", DELEGATE_LOGGER}).level(Level.DEBUG);
    protected ProcessEngine engine1;
    protected ProcessEngine engine2;

    @Before
    public void startEngines() {
        this.engine1 = this.createProcessEngine("engine1");
        this.engine2 = this.createProcessEngine("engine2");
    }

    @After
    public void closeEngine1() {
        try {
            this.engine1.close();
        }
        finally {
            this.engine1 = null;
        }
    }

    @After
    public void closeEngine2() {
        try {
            this.engine2.close();
        }
        finally {
            this.engine2 = null;
        }
    }

    @Test
    public void shouldHaveProcessEngineNameAvailableInMdc() {
        this.engine1.getRepositoryService().createDeployment().addModelInstance("test.bpmn", this.modelOneTaskProcess()).deploy();
        this.engine1.getRuntimeService().startProcessInstanceByKey(PROCESS);
        this.engine1.getTaskService().complete(((Task)this.engine1.getTaskService().createTaskQuery().singleResult()).getId());
        List filteredLog = this.loggingRule.getLog();
        List engineNames = filteredLog.stream().map(log -> (String)log.getMDCPropertyMap().get("engineName")).collect(Collectors.toList());
        Assertions.assertThat(engineNames).hasSize(filteredLog.size());
        Assertions.assertThat(engineNames.stream().distinct().collect(Collectors.toList())).containsExactly((Object[])new String[]{"engine1"});
    }

    @Test
    public void shouldHaveProcessEngineNameAvailableInMdcForAllEngines() {
        this.engine1.getRepositoryService().createDeployment().addModelInstance("test1.bpmn", this.modelLogDelegateProcess()).deploy();
        this.engine2.getRepositoryService().createDeployment().addModelInstance("test2.bpmn", this.modelLogDelegateProcess()).deploy();
        this.engine1.getRuntimeService().startProcessInstanceByKey(PROCESS);
        this.engine2.getRuntimeService().startProcessInstanceByKey(PROCESS);
        List log = this.loggingRule.getFilteredLog("this is a log message from engine");
        List engineNames = log.stream().map(l -> (String)l.getMDCPropertyMap().get("engineName")).collect(Collectors.toList());
        Assertions.assertThat(engineNames).hasSize(log.size());
        Assertions.assertThat(engineNames.stream().distinct().collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"engine1", "engine2"});
        List filteredLogEngine1 = this.loggingRule.getFilteredLog("engine1");
        List engineNamesEngine1 = filteredLogEngine1.stream().map(l -> (String)l.getMDCPropertyMap().get("engineName")).collect(Collectors.toList());
        Assertions.assertThat(engineNamesEngine1).hasSameSizeAs((Iterable)filteredLogEngine1);
        Assertions.assertThat(engineNamesEngine1.stream().distinct().collect(Collectors.toList())).containsExactly((Object[])new String[]{"engine1"});
        List filteredLogEngine2 = this.loggingRule.getFilteredLog("engine2");
        List engineNamesEngine2 = filteredLogEngine2.stream().map(l -> (String)l.getMDCPropertyMap().get("engineName")).collect(Collectors.toList());
        Assertions.assertThat(engineNamesEngine2).hasSameSizeAs((Iterable)filteredLogEngine2);
        Assertions.assertThat(engineNamesEngine2.stream().distinct().collect(Collectors.toList())).containsExactly((Object[])new String[]{"engine2"});
    }

    private ProcessEngine createProcessEngine(String name) {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName(name);
        processEngineConfiguration.setJdbcUrl(String.format("jdbc:h2:mem:%s", name));
        return processEngineConfiguration.buildProcessEngine();
    }

    protected BpmnModelInstance modelOneTaskProcess() {
        return Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").endEvent("end").done();
    }

    protected BpmnModelInstance modelLogDelegateProcess() {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").serviceTask().camundaClass(LogEngineNameDelegate.class.getName())).endEvent("end").done();
    }
}

