/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.form.FormException;
import org.camunda.bpm.engine.impl.form.handler.FormFieldHandler;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.camunda.bpm.engine.impl.form.validator.FormValidators;
import org.camunda.bpm.engine.impl.form.validator.MaxLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MaxValidator;
import org.camunda.bpm.engine.impl.form.validator.MinLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MinValidator;
import org.camunda.bpm.engine.impl.form.validator.ReadOnlyValidator;
import org.camunda.bpm.engine.impl.form.validator.RequiredValidator;
import org.camunda.bpm.engine.test.api.runtime.util.TestVariableScope;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class BuiltInValidatorsTest
extends PluggableProcessEngineTest {
    @Test
    public void testDefaultFormFieldValidators() {
        FormValidators formValidators = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getFormValidators();
        Map validators = formValidators.getValidators();
        Assert.assertEquals(RequiredValidator.class, validators.get("required"));
        Assert.assertEquals(ReadOnlyValidator.class, validators.get("readonly"));
        Assert.assertEquals(MinValidator.class, validators.get("min"));
        Assert.assertEquals(MaxValidator.class, validators.get("max"));
        Assert.assertEquals(MaxLengthValidator.class, validators.get("maxlength"));
        Assert.assertEquals(MinLengthValidator.class, validators.get("minlength"));
    }

    @Test
    public void testRequiredValidator() {
        RequiredValidator validator = new RequiredValidator();
        TestValidatorContext validatorContext = new TestValidatorContext(null);
        Assert.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)validatorContext));
        Assert.assertTrue((boolean)validator.validate((Object)1, (FormFieldValidatorContext)validatorContext));
        Assert.assertTrue((boolean)validator.validate((Object)true, (FormFieldValidatorContext)validatorContext));
        Assert.assertFalse((boolean)validator.validate((Object)"", (FormFieldValidatorContext)validatorContext));
        Assert.assertFalse((boolean)validator.validate(null, (FormFieldValidatorContext)validatorContext));
        validatorContext = new TestValidatorContext(null, "fieldName");
        validatorContext.getVariableScope().setVariable("fieldName", (Object)"existingValue");
        Assert.assertTrue((boolean)validator.validate(null, (FormFieldValidatorContext)validatorContext));
    }

    @Test
    public void testReadOnlyValidator() {
        ReadOnlyValidator validator = new ReadOnlyValidator();
        Assert.assertFalse((boolean)validator.validate((Object)"", null));
        Assert.assertFalse((boolean)validator.validate((Object)"aaa", null));
        Assert.assertFalse((boolean)validator.validate((Object)11, null));
        Assert.assertFalse((boolean)validator.validate((Object)2.0, null));
        Assert.assertTrue((boolean)validator.validate(null, null));
    }

    @Test
    public void testMinValidator() {
        MinValidator validator = new MinValidator();
        Assert.assertTrue((boolean)validator.validate(null, null));
        Assert.assertTrue((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            Assert.fail((String)"exception expected");
        }
        catch (FormException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        Assert.assertFalse((boolean)validator.validate((Object)4.0, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        Assert.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        Assert.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.0f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
        Assert.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.1")));
    }

    @Test
    public void testMaxValidator() {
        MaxValidator validator = new MaxValidator();
        Assert.assertTrue((boolean)validator.validate(null, null));
        Assert.assertTrue((boolean)validator.validate((Object)3, (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertFalse((boolean)validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("3")));
        try {
            validator.validate((Object)4, (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            Assert.fail((String)"exception expected");
        }
        catch (FormException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot validate Integer value 4: configuration 4.4 cannot be parsed as Integer."));
        }
        Assert.assertFalse((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertTrue((boolean)validator.validate((Object)4.1, (FormFieldValidatorContext)new TestValidatorContext("4.2")));
        Assert.assertFalse((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertTrue((boolean)validator.validate((Object)Float.valueOf(4.1f), (FormFieldValidatorContext)new TestValidatorContext("4.2")));
    }

    @Test
    public void testMaxLengthValidator() {
        MaxLengthValidator validator = new MaxLengthValidator();
        Assert.assertTrue((boolean)validator.validate(null, null));
        Assert.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("3")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            Assert.fail((String)"exception expected");
        }
        catch (FormException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot validate \"maxlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    @Test
    public void testMinLengthValidator() {
        MinLengthValidator validator = new MinLengthValidator();
        Assert.assertTrue((boolean)validator.validate(null, null));
        Assert.assertTrue((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4")));
        Assert.assertFalse((boolean)validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("5")));
        try {
            validator.validate((Object)"test", (FormFieldValidatorContext)new TestValidatorContext("4.4"));
            Assert.fail((String)"exception expected");
        }
        catch (FormException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot validate \"minlength\": configuration 4.4 cannot be interpreted as Integer"));
        }
    }

    protected static class TestValidatorContext
    implements FormFieldValidatorContext {
        TestVariableScope variableScope = new TestVariableScope();
        FormFieldHandler formFieldHandler = new FormFieldHandler();
        String configuration;

        public TestValidatorContext(String configuration) {
            this.configuration = configuration;
        }

        public TestValidatorContext(String configuration, String formFieldId) {
            this.configuration = configuration;
            this.formFieldHandler.setId(formFieldId);
        }

        public FormFieldHandler getFormFieldHandler() {
            return this.formFieldHandler;
        }

        public DelegateExecution getExecution() {
            return null;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public Map<String, Object> getSubmittedValues() {
            return null;
        }

        public VariableScope getVariableScope() {
            return this.variableScope;
        }
    }
}

