/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.interceptor;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.standalone.interceptor.ThrowErrorJavaDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CommandContextInterceptorTest
extends PluggableProcessEngineTest {
    @Test
    public void testCommandContextGetCurrentAfterException() {
        try {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    throw new IllegalStateException("here i come!");
                }
            });
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNull((Object)Context.getCommandContext());
    }

    @Test
    public void testCommandContextNestedFailingCommands() {
        final ExceptionThrowingCmd innerCommand1 = new ExceptionThrowingCmd(new IdentifiableRuntimeException(1));
        final ExceptionThrowingCmd innerCommand2 = new ExceptionThrowingCmd(new IdentifiableRuntimeException(2));
        try {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequired();
                    commandExecutor.execute((Command)innerCommand1);
                    commandExecutor.execute((Command)innerCommand2);
                    return null;
                }
            });
            Assert.fail((String)"Exception expected");
        }
        catch (IdentifiableRuntimeException e) {
            Assert.assertEquals((long)1L, (long)e.id);
        }
        Assert.assertTrue((boolean)innerCommand1.executed);
        Assert.assertFalse((boolean)innerCommand2.executed);
    }

    @Test
    public void testCommandContextNestedTryCatch() {
        final ExceptionThrowingCmd innerCommand = new ExceptionThrowingCmd(new IdentifiableRuntimeException(1));
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequired();
                try {
                    commandExecutor.execute((Command)innerCommand);
                    Assert.fail((String)"exception expected to pop up during execution of inner command");
                }
                catch (IdentifiableRuntimeException e) {
                    Assert.assertNull((String)"the exception should not have been propagated to this command's context", (Object)Context.getCommandInvocationContext().getThrowable());
                }
                return null;
            }
        });
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testCommandContextNestedFailingCommandsNotExceptions() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"processThrowingThrowable").startEvent().serviceTask().camundaClass(ThrowErrorJavaDelegate.class)).endEvent().done();
        this.testRule.deploy(modelInstance);
        boolean errorThrown = false;
        try {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    CommandContextInterceptorTest.this.runtimeService.startProcessInstanceByKey("processThrowingThrowable");
                    return null;
                }
            });
            Assert.fail((String)"Exception expected");
        }
        catch (StackOverflowError t) {
            errorThrown = true;
        }
        Assert.assertTrue((boolean)ThrowErrorJavaDelegate.executed);
        Assert.assertTrue((boolean)errorThrown);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
    }

    protected class IdentifiableRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected int id;

        public IdentifiableRuntimeException(int id) {
            this.id = id;
        }
    }

    protected class ExceptionThrowingCmd
    implements Command<Void> {
        protected boolean executed = false;
        protected RuntimeException exceptionToThrow;

        public ExceptionThrowingCmd(RuntimeException e) {
            this.exceptionToThrow = e;
        }

        public Void execute(CommandContext commandContext) {
            this.executed = true;
            throw this.exceptionToThrow;
        }
    }
}

