/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.metadata;

import java.util.HashMap;
import java.util.Properties;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.junit.Assert;
import org.junit.Test;

public class PropertyHelperTest {
    protected static final String JOB_EXECUTOR_DEPLOYMENT_AWARE_PROP = "jobExecutorDeploymentAware";
    protected static final String JOB_EXECUTOR_PREFER_TIMER_JOBS = "jobExecutorPreferTimerJobs";
    protected static final String JOB_EXECUTOR_ACQUIRE_BY_DUE_DATE = "jobExecutorAcquireByDueDate";
    protected static final String MAIL_SERVER_PORT_PROP = "mailServerPort";
    protected static final String JDBC_URL_PROP = "jdbcUrl";
    protected static final String DB_IDENTITY_USED_PROP = "dbIdentityUsed";
    protected static final String MAX_JOBS_PER_ACQUISITION = "maxJobsPerAcquisition";
    protected static final String MAX_WAIT = "maxWait";
    protected static final String WAIT_INCREASE_FACTOR = "waitIncreaseFactor";
    protected static final String BACKOFF_TIME_IN_MILLIS = "backoffTimeInMillis";
    protected static final String KC_JDBC_URL_PROP = "jdbc-url";
    protected static final String KC_DB_IDENTITY_USED_PROP = "db-identity-used";
    protected static final String KC_WAIT_INCREASE_FACTOR = "wait-increase-factor";
    protected static final String KC_BACKOFF_TIME_IN_MILLIS = "backoff-time-in-millis";
    protected static final String SC_JDBC_URL_PROP = "jdbc_url";
    protected static final String SC_DB_IDENTITY_USED_PROP = "db_identity_used";
    protected static final String SC_WAIT_INCREASE_FACTOR = "wait_increase_factor";
    protected static final String SC_BACKOFF_TIME_IN_MILLIS = "backoff_time_in_millis";

    @Test
    public void testProcessEngineConfigurationProperties() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put(JOB_EXECUTOR_DEPLOYMENT_AWARE_PROP, "true");
        propertiesToSet.put(JOB_EXECUTOR_PREFER_TIMER_JOBS, "true");
        propertiesToSet.put(JOB_EXECUTOR_ACQUIRE_BY_DUE_DATE, "true");
        propertiesToSet.put(MAIL_SERVER_PORT_PROP, "42");
        propertiesToSet.put(JDBC_URL_PROP, "someUrl");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertTrue((boolean)engineConfiguration.isJobExecutorDeploymentAware());
        Assert.assertTrue((boolean)engineConfiguration.isJobExecutorPreferTimerJobs());
        Assert.assertTrue((boolean)engineConfiguration.isJobExecutorAcquireByDueDate());
        Assert.assertEquals((long)42L, (long)engineConfiguration.getMailServerPort());
        Assert.assertEquals((Object)"someUrl", (Object)engineConfiguration.getJdbcUrl());
    }

    @Test
    public void testJobExecutorConfigurationProperties() {
        DefaultJobExecutor jobExecutor = new DefaultJobExecutor();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put(MAX_JOBS_PER_ACQUISITION, Integer.toString(Integer.MAX_VALUE));
        propertiesToSet.put(MAX_WAIT, Long.toString(Long.MAX_VALUE));
        propertiesToSet.put(WAIT_INCREASE_FACTOR, Float.toString(Float.MAX_VALUE));
        propertiesToSet.put(BACKOFF_TIME_IN_MILLIS, Integer.toString(Integer.MAX_VALUE));
        PropertyHelper.applyProperties((Object)jobExecutor, propertiesToSet);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)jobExecutor.getMaxJobsPerAcquisition());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)jobExecutor.getMaxWait());
        Assert.assertEquals((double)3.4028234663852886E38, (double)jobExecutor.getWaitIncreaseFactor(), (double)1.0E-4);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)jobExecutor.getBackoffTimeInMillis());
    }

    @Test
    public void testConfigurationPropertiesWithMismatchingFieldAndSetter() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put(DB_IDENTITY_USED_PROP, "false");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertFalse((boolean)engineConfiguration.isDbIdentityUsed());
        propertiesToSet.put(DB_IDENTITY_USED_PROP, "true");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertTrue((boolean)engineConfiguration.isDbIdentityUsed());
    }

    @Test
    public void testNonExistingPropertyForProcessEngineConfiguration() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put("aNonExistingProperty", "someValue");
        try {
            PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResolvePropertyForExistingProperty() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"${camunda.test.someKey}");
        Assert.assertEquals((Object)"1234", (Object)result);
    }

    @Test
    public void testResolvePropertyWhitespaceAndMore() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)" -${ camunda.test.someKey }- ");
        Assert.assertEquals((Object)" -1234- ", (Object)result);
    }

    @Test
    public void testResolvePropertyForMultiplePropertes() {
        Properties source = new Properties();
        source.put("camunda.test.oneKey", "1234");
        source.put("camunda.test.anotherKey", "5678");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"-${ camunda.test.oneKey }-${ camunda.test.anotherKey}-");
        Assert.assertEquals((Object)"-1234-5678-", (Object)result);
    }

    @Test
    public void testResolvePropertyForMissingProperty() {
        Properties source = new Properties();
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"${camunda.test.someKey}");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testResolvePropertyNoTemplate() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"camunda.test.someKey");
        Assert.assertEquals((Object)"camunda.test.someKey", (Object)result);
    }

    @Test
    public void shouldResolveKebabCaseProperties() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        DefaultJobExecutor jobExecutor = new DefaultJobExecutor();
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put(KC_JDBC_URL_PROP, "someUrl");
        configProperties.put(KC_DB_IDENTITY_USED_PROP, "true");
        HashMap<String, String> executorProperties = new HashMap<String, String>();
        executorProperties.put(KC_BACKOFF_TIME_IN_MILLIS, Integer.toString(Integer.MAX_VALUE));
        executorProperties.put(KC_WAIT_INCREASE_FACTOR, Float.toString(Float.MAX_VALUE));
        PropertyHelper.applyProperties((Object)engineConfiguration, configProperties, (String)"-");
        PropertyHelper.applyProperties((Object)jobExecutor, executorProperties, (String)"-");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)jobExecutor.getBackoffTimeInMillis());
        Assert.assertEquals((double)3.4028234663852886E38, (double)jobExecutor.getWaitIncreaseFactor(), (double)1.0E-4);
        Assert.assertEquals((Object)true, (Object)engineConfiguration.isDbIdentityUsed());
        Assert.assertEquals((Object)"someUrl", (Object)engineConfiguration.getJdbcUrl());
    }

    @Test
    public void shouldResolveSnakeCaseProperties() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        DefaultJobExecutor jobExecutor = new DefaultJobExecutor();
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put(SC_JDBC_URL_PROP, "someUrl");
        configProperties.put(SC_DB_IDENTITY_USED_PROP, "true");
        HashMap<String, String> executorProperties = new HashMap<String, String>();
        executorProperties.put(SC_BACKOFF_TIME_IN_MILLIS, Integer.toString(Integer.MAX_VALUE));
        executorProperties.put(SC_WAIT_INCREASE_FACTOR, Float.toString(Float.MAX_VALUE));
        PropertyHelper.applyProperties((Object)engineConfiguration, configProperties, (String)"_");
        PropertyHelper.applyProperties((Object)jobExecutor, executorProperties, (String)"_");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)jobExecutor.getBackoffTimeInMillis());
        Assert.assertEquals((double)3.4028234663852886E38, (double)jobExecutor.getWaitIncreaseFactor(), (double)1.0E-4);
        Assert.assertEquals((Object)true, (Object)engineConfiguration.isDbIdentityUsed());
        Assert.assertEquals((Object)"someUrl", (Object)engineConfiguration.getJdbcUrl());
    }
}

